package cn.com.duiba.wechat.server.api.dto.qrcode;

import cn.com.duiba.wechat.server.api.enums.QrcodeStateEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/4/18 09:42
 */
@Getter
@Setter
@ToString
public class SelfQrcodeDTO implements Serializable {

    /**
     * 二维码id
     */
    private Long id;

    /**
     * 二维码名称
     */
    private String name;

    /**
     * 跳转地址
     */
    private String url;

    /**
     * 启用状态，0 禁用，1 启用
     * @see QrcodeStateEnum
     */
    private Integer state;

    /**
     * 父级二维码id
     */
    private Long parentId;

    /**
     * 备注
     */
    private String remark;
}
