package cn.com.duiba.wechat.server.api.param.groupsendtask;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class UpdateGroupSendTaskParam implements Serializable {

    private static final long serialVersionUID = 3116538067576659000L;
    /**
     * 任务ID
     */
    @NotNull(message = "任务ID不能为空")
    private Long id;
    /**
     * 素材ID
     */
    private String mediaId;

    /**
     * 素材标题
     */
    private String mediaName;

    /**
     * 素材类型
     */
    private Integer materialType;
    /**
     * 1:立即群发，2：定时群发
     */
    private Integer sendType;

    /**
     * '发送时间'
     */
    private Date sendTime;

    /**
     * 群发范围 1:全部，2:定向
     */
    private Integer sendRange;

    /**
     * 用户限制 1. 全部用户 2:仅零售户
     */
    private Integer userLimit;

    /**
     * '地区限制'
     */
    private String province;

    private String city;

    private String area;

    /**
     * 标签配置
     */
    private List<Long> tagConfig;

    /**
     * 客户群配置
     */
    private Long customerGroupConfig;

    /**
     * 测试人员
     */
    private String testUser;

}
