package cn.com.duiba.wechat.server.api.param.manualpush;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CreateManualPushParam implements Serializable {

    private static final long serialVersionUID = 3530885801027132092L;

    @NotBlank(message = "推送名称不能为空")
    @Size(max = 50,message = "推送名称最大50个字符")
    private String pushName;

    /**
     * 1:立即推送，2：定时推送
     */
    @NotNull(message = "推送类型不能为空")
    private Integer pushType;

    /**
     * 推送时间
     */
    private Date pushDate;


    @NotNull(message = "推送范围不能为空")
    private Integer pushRange;


    /**
     * 用户限制 1. 全部用户 2:仅零售户
     */
    private Integer userLimit;

    /**
     * '地区限制'
     */
    private String province;

    private String city;

    private String district;

    /**
     * 标签ID
     */
    private List<Long> tagConfig;

    /**
     * 客户群id
     */
    private Long customerGroupConfig;

    /**
     * 模版ID
     */
    @NotBlank(message = "模版ID不能为空")
    private String templateId;

    /**
     * 模版参数映射
     */
    private JSONObject paramConfig;

    /**
     * 跳转url
     */
    private String url;

    /**
     * 测试人员
     */
    private String testUser;

    /**
     * 创建人
     */
    private String createBy;
}
