package cn.com.duiba.wechat.server.api.constant.enums;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.util.stream.Stream;
import lombok.Getter;

/**
 * @author xuanhongjian
 */
@Getter
public enum TemplatePushStatusEnum {
    /**
     * 模版推送可能状态
     */
    SUCCESS("success", "成功", 1),
    REJECT("failed:user block", "用户拒收", 2),
    FAIL("failed: system failed", "发送失败（非用户拒绝）", 3),
    UNKNOWN("unknown status", "未知状态", 4),
    ;

    private static final ImmutableMap<String, TemplatePushStatusEnum> INNER_MAP;

    static {
        Builder<String, TemplatePushStatusEnum> builder = ImmutableMap.builder();
        Stream.of(TemplatePushStatusEnum.values()).forEach(templatePushStatusEnum -> {
            builder.put(templatePushStatusEnum.status, templatePushStatusEnum);
        });
        INNER_MAP = builder.build();
    }

    private final String status;
    private final String desc;
    private final Integer code;

    TemplatePushStatusEnum(String status, String desc, Integer code) {
        this.status = status;
        this.desc = desc;
        this.code = code;
    }

    public static TemplatePushStatusEnum getByStatus(String status) {
        return INNER_MAP.get(status) == null ? UNKNOWN : INNER_MAP.get(status);
    }

    public static TemplatePushStatusEnum getByCode(Integer code) {
        TemplatePushStatusEnum[] values = TemplatePushStatusEnum.values();
        TemplatePushStatusEnum statusEnum = TemplatePushStatusEnum.UNKNOWN;
        for (TemplatePushStatusEnum templatePushStatusEnum : values) {
            if (Objects.equal(code, templatePushStatusEnum.getCode())) {
                statusEnum = templatePushStatusEnum;
                break;
            }
        }
        return statusEnum;
    }
}
