package cn.com.duiba.wechat.server.api.param.qrcode;

import lombok.Getter;
import lombok.Setter;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/4/13 17:26
 */
@Getter
@Setter
public class RemoteSelfQrcodeCreateParam implements Serializable {

    /**
     * 二维码名称
     */
    @NotBlank(message = "请输入二维码名称")
    @Length(max = 20)
    private String name;

    /**
     * 跳转地址
     */
    @NotBlank(message = "请输入跳转地址")
    @Length(max = 2000)
    private String url;

    /**
     * 生成数量
     */
    @NotNull(message = "请输入生成数量")
    @Max(value = 20000, message = "生成数量仅支持1至20000")
    @Min(value = 1, message = "生成数量仅支持1至20000")
    private Long num;
}
