package cn.com.duiba.wechat.server.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wechat.server.api.dto.groupsendtask.GroupSendTaskDTO;
import cn.com.duiba.wechat.server.api.param.groupsendtask.CreateGroupSendTaskParam;
import cn.com.duiba.wechat.server.api.param.groupsendtask.PageQueryParam;
import cn.com.duiba.wechat.server.api.param.groupsendtask.IdParam;
import cn.com.duiba.wechat.server.api.param.groupsendtask.UpdateGroupSendTaskParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 图文消息 群发任务管理
 *
 * @author xuanhongjian
 */
@AdvancedFeignClient
public interface RemoteGroupSendTaskService {

    /**
     * 创建 群发任务
     *
     * @param param 参数
     * @return ID
     * @throws BizException 业务异常
     */
    Long createGroupSendTask(CreateGroupSendTaskParam param) throws BizException;

    /**
     * 修改群发任务
     *
     * @param param 参数
     * @return 操作结果
     * @throws BizException 业务异常
     */
    Boolean updateGroupSendTask(UpdateGroupSendTaskParam param) throws BizException;

    /**
     * 根据任务ID获取任务详情
     *
     * @param param 任务ID
     * @return 任务详情
     */
    GroupSendTaskDTO getTaskById(IdParam param) throws BizException;

    /**
     * 分页查询任务
     *
     * @param param 参数
     * @return 任务列表
     */
    PageResponse<GroupSendTaskDTO> pageQueryTask(PageQueryParam param);

    /**
     * 撤销定时任务
     *
     * @param param 参数
     * @return 结果
     */
    Boolean revokeTask(IdParam param) throws BizException;
}
