package cn.com.duiba.wechat.server.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wechat.server.api.dto.template.WxMessageTemplateDTO;
import cn.com.duiba.wechat.server.api.param.template.TemplateQueryParam;

import java.util.List;

/**
 * 消息模板
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/1/26 11:15 上午
 **/
@AdvancedFeignClient
public interface RemoteMsgTemplateService {
    /**
     * 最后同步时间
     *
     * @return
     */
    Long lastSynTime();

    /**
     * 同步消息模板
     *
     * @throws BizException
     */
    void synMsgTemplate() throws BizException;

    /**
     * 查询消息模板列表
     * 有效消息模板，最多只会有25条，不需要分页
     *
     * @param param
     * @return
     */
    List<WxMessageTemplateDTO> queryMsgTemplateList(TemplateQueryParam param);

    /**
     * 模板Id查询模板信息
     *
     * @param templateId
     * @return
     */
    WxMessageTemplateDTO queryMsgTemplateByTemplateId(String templateId);
}
