package cn.com.duiba.wechat.server.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wechat.server.api.dto.qrcode.SelfQrcodeDTO;
import cn.com.duiba.wechat.server.api.dto.qrcode.SelfQrcodeDailyScanDataDTO;
import cn.com.duiba.wechat.server.api.dto.qrcode.SelfQrcodeEditDetailDTO;
import cn.com.duiba.wechat.server.api.dto.qrcode.SelfQrcodePageDTO;
import cn.com.duiba.wechat.server.api.dto.qrcode.SelfQrcodePageDetailDTO;
import cn.com.duiba.wechat.server.api.param.qrcode.RemoteQrcodeUpdateStateParam;
import cn.com.duiba.wechat.server.api.param.qrcode.RemoteSelfQrcodeCountPvUvParam;
import cn.com.duiba.wechat.server.api.param.qrcode.RemoteSelfQrcodeCreateParam;
import cn.com.duiba.wechat.server.api.param.qrcode.RemoteSelfQrcodeDetailPageParam;
import cn.com.duiba.wechat.server.api.param.qrcode.RemoteSelfQrcodeGenerateParam;
import cn.com.duiba.wechat.server.api.param.qrcode.RemoteSelfQrcodePageParam;
import cn.com.duiba.wechat.server.api.param.qrcode.RemoteSelfQrcodeUpdateParam;
import cn.com.duiba.wechat.server.api.param.qrcode.RemoteSelfQrcodeUpdateRemarkParam;
import cn.com.duiba.wolf.entity.PageResponse;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022-04-08 11:09:42
 */
@AdvancedFeignClient
public interface RemoteSelfQrcodeService {


    /**
     * 新建二维码
     *
     * @param param 创建参数
     * @throws BizException         创建异常
     * @throws InterruptedException 加锁异常
     */
    void createQrcode(RemoteSelfQrcodeCreateParam param) throws BizException, InterruptedException;

    /**
     * 分页查询自建二维码
     *
     * @param param 分页查询参数
     * @return PageResponse<SelfQrcodePageDTO>
     */
    PageResponse<SelfQrcodePageDTO> pageList(RemoteSelfQrcodePageParam param);

    /**
     * 查看编辑详情
     *
     * @param id 自建二维码ID
     * @return SelfQrcodeEditDetailDTO
     * @throws BizException 查询异常
     */
    SelfQrcodeEditDetailDTO editDetail(@NotNull(message = "二维码ID不能为空") Long id) throws BizException;

    /**
     * 查看详情列表
     *
     * @param param 查询参数
     * @return PageResponse<SelfQrcodePageDetailDTO>
     * @throws BizException 查询异常
     */
    PageResponse<SelfQrcodePageDetailDTO> detailList(RemoteSelfQrcodeDetailPageParam param) throws BizException;

    /**
     * 生成二维码
     *
     * @param param 生成参数
     * @throws BizException         创建异常
     * @throws InterruptedException 加锁异常
     */
    void generateQrcode(RemoteSelfQrcodeGenerateParam param) throws BizException, InterruptedException;

    /**
     * 编辑保存
     *
     * @param param 编辑参数
     * @throws BizException 二维码ID不存在
     */
    void update(RemoteSelfQrcodeUpdateParam param) throws BizException;

    /**
     * 删除
     *
     * @param id 二维码ID
     * @throws BizException 二维码ID不存在
     */
    void delete(@NotNull(message = "二维码ID不能为空") Long id) throws BizException;

    /**
     * 启用/禁用
     *
     * @param param 操作参数
     * @throws BizException 启用/禁用异常
     */
    void enableOrDisable(RemoteQrcodeUpdateStateParam param) throws BizException;

    /**
     * 根据上级id查询子二维码
     *
     * @param parentId 上级id
     * @return List<SelfQrcodeDTO>
     */
    List<SelfQrcodeDTO> getByParentId(Long parentId);

    /**
     * 根据二维码ID获取二维码信息
     *
     * @param id 二维码ID
     * @return SelfQrcodeDTO
     */
    SelfQrcodeDTO getById(Long id);

    /**
     * 保存统计pv、uv
     *
     * @param param 保存参数
     * @throws BizException 保存异常
     * @throws InterruptedException 加锁异常
     */
    void countPvUv(RemoteSelfQrcodeCountPvUvParam param) throws BizException, InterruptedException;

    /**
     * 修改备注
     *
     * @param param 修改参数
     * @throws BizException 修改异常
     */
    void updateRemark(RemoteSelfQrcodeUpdateRemarkParam param) throws BizException;

    /**
     * 查询一段时间内每日扫码数据
     * @param param 查询参数
     * @return List<SelfQrcodeDailyScanDataDTO>
     * @throws BizException 查询异常
     */
    List<SelfQrcodeDailyScanDataDTO> getDailyScanData(RemoteSelfQrcodeDetailPageParam param) throws BizException;
}
