package cn.com.duiba.wechat.server.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wechat.server.api.dto.qrcode.WechatDataDetailsDTO;
import cn.com.duiba.wechat.server.api.dto.qrcode.WechatDataOverviewDTO;
import cn.com.duiba.wechat.server.api.dto.qrcode.WechatDataTrendDTO;
import cn.com.duiba.wechat.server.api.dto.qrcode.WechatQrcodeDetailDTO;
import cn.com.duiba.wechat.server.api.dto.qrcode.WechatQrcodePageDTO;
import cn.com.duiba.wechat.server.api.param.qrcode.RemoteQrcodeUpdateParam;
import cn.com.duiba.wechat.server.api.param.qrcode.RemoteQrcodeUpdateStateParam;
import cn.com.duiba.wechat.server.api.param.qrcode.RemoteWechatCreateQrcodeParam;
import cn.com.duiba.wechat.server.api.param.qrcode.RemoteWechatQrcodeDataDetailsParam;
import cn.com.duiba.wechat.server.api.param.qrcode.RemoteWechatQrcodeDataTrendParam;
import cn.com.duiba.wechat.server.api.param.qrcode.RemoteWechatQrcodePageParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.io.IOException;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/4/7 17:56
 */
@AdvancedFeignClient
public interface RemoteWxQrcodeService {

    /**
     * 创建微信二维码
     * @param param 请求参数
     * @throws BizException 创建微信二维码异常
     * @throws InterruptedException 加锁异常
     * @throws IOException 上传oss异常
     */
    void createWxQrcode(RemoteWechatCreateQrcodeParam param) throws BizException, InterruptedException, IOException;

    /**
     * 分页查询微信二维码
     * @param param 分页参数
     * @return PageResponse<WechatQrcodePageDTO>
     */
    PageResponse<WechatQrcodePageDTO> pageList(RemoteWechatQrcodePageParam param);

    /**
     * 获取微信二维码详情信息
     * @param id 二维码ID
     * @return WechatQrcodeDetailDTO
     * @throws BizException 获取微信二维码异常
     */
    WechatQrcodeDetailDTO details(Long id) throws BizException;

    /**
     * 编辑保存微信二维码
     * @param param 请求参数
     * @throws BizException 编辑保存微信二维码异常
     */
    void edit(RemoteQrcodeUpdateParam param) throws BizException, IOException;

    /**
     * 查看数据概览
     * @param id 二维码ID
     * @return WechatDataOverviewDTO
     * @throws BizException 查询异常
     */
    WechatDataOverviewDTO dataOverview(Long id) throws BizException;

    /**
     * 查看数据趋势
     * @param param 查询参数
     * @return List<WechatDataTrendDTO>
     * @throws BizException 创建微信二维码异常
     */
    List<WechatDataTrendDTO> dataTrend(RemoteWechatQrcodeDataTrendParam param) throws BizException;

    /**
     * 查看数据明细
     * @param param 查询参数
     * @return List<WechatDataDetailsDTO>
     * @throws BizException 查看数据明细异常
     */
    List<WechatDataDetailsDTO> dataDetails(RemoteWechatQrcodeDataDetailsParam param) throws BizException;

    /**
     * 删除微信二维码
     * @param id 二维码ID
     * @throws BizException 删除异常
     */
    void delete(Long id) throws BizException;

    /**
     * 启用/禁用
     * @param param 操作参数
     * @throws BizException 启用/禁用异常
     */
    void enableOrDisable(RemoteQrcodeUpdateStateParam param) throws BizException;
}
