package cn.com.duiba.wechat.server.api.constant;

import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * 集中管理redis key生成
 *
 * @author xuanhongjian
 */
public class RedisKeyGenerator {

    /**
     * 统计每分钟已经发送了多少次群发接口
     */
    private static final String GROUP_SEND_COUNT_MINUTE = "WECHAT_SERVICE_GROUP_MINUTE_SEND_COUNT:{0}";
    /**
     * 统计每天已经发送了多少次群发接口
     */
    private static final String GROUP_SEND_COUNT_DAY = "WECHAT_SERVICE_GROUP_DAY_SEND_COUNT:{0}";

    /**
     * 批处理任务下子任务数目
     */
    private static final String TASK_COUNT = "WECHAT_SERVICE_TASK_COUNT:{0}";
    /**
     * 统计每分钟群发接口调用了多少次
     */
    private static final DateTimeFormatter MINUTE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    /**
     * 统计每天钟群发接口调用了多少次
     */
    private static final DateTimeFormatter DAY_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static String buildTaskCountKey(String taskId) {
        return MessageFormat.format(TASK_COUNT, taskId);
    }

    public static String buildGroupSendCountMinute() {
        return MessageFormat.format(GROUP_SEND_COUNT_MINUTE,MINUTE_FORMAT.format(LocalDateTime.now()));
    }

    public static String buildGroupSendCountDay() {
        return MessageFormat.format(GROUP_SEND_COUNT_DAY,DAY_FORMAT.format(LocalDateTime.now()));
    }
}
