package cn.com.duiba.wechat.server.api.constant;


/**
 * 微信url常数
 *
 * @author zouweixiang
 * @date 2021/11/22
 */
public class WeChatUrlConstant {

	private WeChatUrlConstant() {
		super();
	}

	/**
	 * 生成带参数二维码
	 */
	public static final String API_QRCODE_CREATE = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=";


	/**
	 * 获取component_access_token的url
	 */
	public static final String API_COMPONENT_TOKEN = "https://api.weixin.qq.com/cgi-bin/component/api_component_token";

	/**
	 * 网页授权通过code换取access_token
	 */
	public static final String API_OAUTH2 = "https://api.weixin.qq.com/sns/oauth2/component/access_token";

	/**
	 * 通过网页授权access_token获取用户基本信息（需授权作用域为snsapi_userinfo）
	 */
	public static final String USERINFO = "https://api.weixin.qq.com/sns/userinfo";

	/**
	 * 获取用户基本信息（包括UnionID机制）
	 */
	public static final String MPUSERINFO = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=";

	/**
	 * 获取（刷新）授权公众号的接口调用凭据（令牌）
	 */
	public static final String API_AUTHORIZER_TOKEN = "https://api.weixin.qq.com/cgi-bin/component/api_authorizer_token?component_access_token=";

	/**
	 * 获取预授权码url
	 */
	public static final String API_CREATE_PREAUTHCODE = "https://api.weixin.qq.com/cgi-bin/component/api_create_preauthcode?component_access_token=";


	/**
	 * 公众号发送模板消息
	 */
	public static final String API_TEMPLATE_SEND = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=";

	/**
	 * 用户网页授权
	 */
	public static final String API_OAUTH2_AUTHORIZE = "https://open.weixin.qq.com/connect/oauth2/authorize";

	/**
	 * 获取用户列表
	 */
	public static final String API_AUTHORIZE_USER = "https://api.weixin.qq.com/cgi-bin/user/get?access_token=";

	/**
	 * 客服接口-发消息
	 */
	public static final String API_CONSUMER_MESSAGE_SEND = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=";



	public static final String API_GET_JSTICKET_URL = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?type=jsapi&access_token=";

	/**
	 * 获取公众号已创建的标签
	 */
	public static final String API_GET_TAG_URL = "https://api.weixin.qq.com/cgi-bin/tags/get?access_token=";

	/**
	 * 创建标签
	 */
	public static final String API_CREATE_TAG_URL = "https://api.weixin.qq.com/cgi-bin/tags/create?access_token=";

	/**
	 * 编辑标签
	 */
	public static final String API_UPDATE_TAG_URL = "https://api.weixin.qq.com/cgi-bin/tags/update?access_token=";

	/**
	 * 删除标签
	 */
	public static final String API_DELETE_TAG_URL = "https://api.weixin.qq.com/cgi-bin/tags/delete?access_token=";

	/**
	 * 获取标签下粉丝列表
	 */
	public static final String API_GET_TAG_USER_URL = "https://api.weixin.qq.com/cgi-bin/user/tag/get?access_token=";

	/**
	 * 批量为用户打标签
	 */
	public static final String API_TAG_BATCH_TAG_URL = "https://api.weixin.qq.com/cgi-bin/tags/members/batchtagging?access_token=";

	/**
	 * 批量为用户取消标签
	 */
	public static final String API_TAG_BATCH_UN_TAG_URL = "https://api.weixin.qq.com/cgi-bin/tags/members/batchuntagging?access_token=";


	/**
	 * 获取临时媒体文件
	 */
	public static final String API_GET_MEDIA = "https://api.weixin.qq.com/cgi-bin/media/get?access_token=";
	public static final String API_GET_MEDIA_VIDEO = "http://api.weixin.qq.com/cgi-bin/media/get?access_token=";

	/**
	 * api获得媒体jssdk
	 */
	public static final String API_GET_MEDIA_JSSDK = "https://api.weixin.qq.com/cgi-bin/media/get/jssdk?access_token=";

	/**
	 * 获取授权页面地址
	 */
	public static final String COMPONENT_LOGIN_PAGE = "https://mp.weixin.qq.com/cgi-bin/componentloginpage?";

	/**
	 * 使用授权码换取公众号的接口调用凭据和授权信息url
	 */
	public static final String API_QUERY_AUTH = "https://api.weixin.qq.com/cgi-bin/component/api_query_auth?component_access_token=";

	/**
	 * 获取授权方公账号信息
	 */
	public static final String API_GET_AUTHORIZER_INFO = "https://api.weixin.qq.com/cgi-bin/component/api_get_authorizer_info?component_access_token=";

	/**
	 * 获取授权方公账号信息
	 */
	public static final String API_GET_JSAPI_TICKET = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?type=jsapi&access_token=";

	/**
	 * 素材列表
	 */
	public static final String MATERIAL_LIST = "https://api.weixin.qq.com/cgi-bin/material/batchget_material?access_token=";

	/**
	 * 草稿列表
	 */
	public static final String DRAFT_LIST = "https://api.weixin.qq.com/cgi-bin/draft/batchget?access_token=";

	/**
	 * 素材预览
	 */
	public static final String MATERIAL_PREVIEW = "https://api.weixin.qq.com/cgi-bin/message/mass/preview?access_token=";

	/**
	 * 按标签群发
	 */
	public static final String SEND_ALL_BY_TAG = "https://api.weixin.qq.com/cgi-bin/message/mass/sendall?access_token=";

	/**
	 * 按openId群发
	 */
	public static final String SEND_ALL_BY_OPEN = "https://api.weixin.qq.com/cgi-bin/message/mass/send?access_token=";

	/**
	 * 群发状态
	 */
	public static final String SEND_ALL_STATUS = "https://api.weixin.qq.com/cgi-bin/message/mass/get?access_token=";

	/**
	 * 获取永久素材内容
	 */
	public static final String GET_PERMANENT_MEDIA = "https://api.weixin.qq.com/cgi-bin/material/get_material?access_token=";

	/**
	 * 获取草稿内容
	 */
	public static final String GET_DRAFT = "https://api.weixin.qq.com/cgi-bin/draft/get?access_token=";

	/**
	 * 获取消息模板
	 */
	public static final String GET_ALL_PRIVATE_TEMPLATE = "https://api.weixin.qq.com/cgi-bin/template/get_all_private_template?access_token=";

	/**
	 * 创建菜单
	 */
	public static final String MENU_CREATE = "https://api.weixin.qq.com/cgi-bin/menu/create?access_token=";

	/**
	 * 获取菜单
	 */
	public static final String GET_CURRENT_SELFMENU_INFO = "https://api.weixin.qq.com/cgi-bin/get_current_selfmenu_info?access_token=";

	/**
	 * 获取累计用户数据
	 */
	public static final String GET_USER_CUMULATE = "https://api.weixin.qq.com/datacube/getusercumulate?access_token=";
}
