package cn.com.duiba.wechat.server.api.dto.qrcode;

import cn.com.duiba.wechat.server.api.enums.ScanOperateType;
import cn.com.duiba.wechat.server.api.enums.ScanTypeEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/8/4 16:16
 **/
@Getter
@Setter
@ToString
public class ScanFocusRecordDTO implements Serializable {

    /**
     * 主键id
     */
    private Long id;

    /**
     * 扫码用户id
     */
    private String userId;

    /**
     * 二维码id
     */
    private Long bizId;

    /**
     * 扫码类型，0 微信二维码，1 自建二维码
     * @see ScanTypeEnum
     */
    private Integer bizType;

    /**
     * 操作类型，0 扫码，1 扫码且关注
     * @see ScanOperateType
     */
    private Integer operateType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}
