package cn.com.duiba.wechat.server.api.dto.qrcode;

import cn.com.duiba.wechat.server.api.enums.LogoTypeEnum;
import cn.com.duiba.wechat.server.api.enums.QrCodeTypeEnum;
import cn.com.duiba.wechat.server.api.enums.QrcodeStateEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/7/19 17:04
 **/
@Getter
@Setter
@ToString
public class WechatQrcodeDTO implements Serializable {

    /**
     * 二维码id
     */
    private Long id;

    /**
     * 场景名称
     */
    private String name;

    /**
     * logo
     */
    private String logo;

    /**
     * logo类型, 0 无logo, 1 使用公众号头像, 2 自定义图片
     *
     * @see LogoTypeEnum
     */
    private Integer logoType;

    /**
     * 二维码下载地址
     */
    private String url;

    /**
     * 二维码url
     */
    private String qrcodeUrl;

    /**
     * 微信二维码类型, 0 临时码，1 永久码
     *
     * @see QrCodeTypeEnum
     */
    private Integer type;

    /**
     * 过期时间
     */
    private Date expireTime;

    /**
     * 是否开启扫码粉丝打标，0 否，1 是
     */
    private Boolean mark;

    /**
     * 是否开启扫码后自动回复，0 否，1 是
     */
    private Boolean autoResp;

    /**
     * 扩展信息，包含打标 list, 回复内容list
     * @see WechatQrcodeExtraDTO
     */
    private String extra;

    /**
     * 启用状态,0禁用，1启用
     *
     * @see QrcodeStateEnum
     */
    private Integer state;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 创建时间
     */
    private Date gmtCreate;
}
