package cn.com.duiba.wechat.server.api.dto.qrcode;

import cn.com.duiba.wechat.server.api.enums.QrCodeTypeEnum;
import cn.com.duiba.wechat.server.api.enums.QrcodeStateEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/4/11 16:20
 */
@Getter
@Setter
@ToString
public class WechatQrcodePageDTO implements Serializable {

    /**
     * 二维码id
     */
    private Long id;

    /**
     * 场景名称
     */
    private String name;

    /**
     * 昨日扫码人数
     */
    private Long lastScanNum;

    /**
     * 昨日关注人数
     */
    private Long lastSubscribeNum;

    /**
     * 二维码下载地址
     */
    private String url;

    /**
     * 二维码地址
     */
    private String qrcodeUrl;

    /**
     * 微信二维码类型, 0 临时码，1 永久码
     *
     * @see QrCodeTypeEnum
     */
    private Integer type;

    /**
     * 启用状态,-1 过期，0 禁用，1启用
     *
     * @see QrcodeStateEnum
     */
    private Integer state;

    /**
     * 过期时间
     */
    private Date expireTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;
}
