package cn.com.duiba.wechat.server.api.dto.record;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 微信操作记录
 */
@Data
public class WxOptRecordDTO implements Serializable {

    private static final long serialVersionUID = 8878949725332684693L;
    private Long id;

    /**
     * 操作类型
     *
     * @see cn.com.duiba.wechat.server.api.enums.OptRecordTypeEnum
     */
    private Integer optType;

    /**
     * 完成事件
     */
    private Date doneTime;

    /**
     * 内容
     */
    private String content;

    /**
     * 备注
     */
    private String memo;

    /**
     * 版本
     */
    private Long version;

    /**
     * 操作人
     */
    private String optUser;

    /**
     * 操作状态
     *
     * @see cn.com.duiba.wechat.server.api.enums.OptRecordStatusEnum
     */
    private Integer optStatus;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 创建时间
     */
    private Date gmtCreate;
}