package cn.com.duiba.wechat.server.api.dto.templatepush;

import cn.com.duiba.wechat.server.api.constant.enums.PushScenesEnum;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * @author xuanhongjian
 */
@Data
public class AutoPushConfigDetailDTO implements Serializable {

    private static final long serialVersionUID = 6839201612756340667L;

    private Long id;
    /**
     * 推送名称
     */
    private String pushName;

    /**
     * 推送场景 {@link PushScenesEnum}
     */
    private Integer pushScene;

    /**
     * 指定的活动类型 使用,分割多个类型
     */
    private List<String> activityTypes;

    /**
     * 模版ID
     */
    private String templateId;

    /**
     * 模版名称
     */
    private String templateName;

    /**
     * 跳转地址
     */
    private String url;

    /**
     * 参数配置
     */
    private JSONObject paramConfig;

    /**
     * 提前多少小时通知
     */
    private Integer warningHour;

    /**
     * 启用状态
     */
    private Integer statue;
}
