package cn.com.duiba.wechat.server.api.param.material;

import lombok.Data;

import java.io.Serializable;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2022/3/1
 */
@Data
public class RemoteWxMaterialQueryParam  implements Serializable {

    /**
     * 当前页码。从1开始计数
     */
    protected int pageNo;

    /**
     * 每页记录数
     */
    protected int pageSize;


    /**
     * 素材id
     */
    private String materialId;

    /**
     * 素材标题
     */
    private String title;

    /**
     * 素材类型 1、图文 2、图片 3、视频 4、音频
     */
    private Integer type;

    public int getOffset() {
        return (this.pageNo - 1) * this.pageSize;
    }
}
