package cn.com.duiba.wechat.server.api.param.qrcode;

import cn.com.duiba.wechat.server.api.enums.ScanOperateType;
import cn.com.duiba.wechat.server.api.enums.ScanTypeEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/8/4 16:31
 **/
@Getter
@Setter
@ToString
public class RemoteScanFocusRecordParam implements Serializable {

    /**
     * 业务id
     */
    @NotNull(message = "业务id不能为空")
    private Long bizId;

    /**
     * 扫码类型，0 微信二维码，1 自建二维码
     * @see ScanTypeEnum
     */
    @NotNull(message = "扫码类型不能为空")
    private Integer bizType;

    /**
     * 操作类型，0 扫码，1 扫码且关注
     * @see ScanOperateType
     */
    @NotNull(message = "操作类型不能为空")
    private Integer operateType;
}
