package cn.com.duiba.wechat.server.api.param.qrcode;

import cn.com.duiba.wechat.server.api.enums.QrCodeTypeEnum;
import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Getter;
import lombok.Setter;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/4/11 16:31
 */
@Getter
@Setter
public class RemoteWechatQrcodePageParam extends PageRequest {

    /**
     * 二维码ID
     */
    private Long id;

    /**
     * 场景名称
     */
    private String name;

    /**
     * 状态
     */
    private Integer state;

    /**
     * 过期开始时间
     */
    private Long expireStartTime;

    /**
     * 过期结束时间
     */
    private Long expireEndTime;

    /**
     * 创建开始时间
     */
    private Long createStartTime;

    /**
     * 创建结束时间
     */
    private Long createEndTime;

    /**
     * 是否需要根据昨日扫码人数倒序排列, 为空则默认根据二维码id排序
     */
    private Boolean lastScan;

    /**
     * 是否需要根据昨日关注人数倒序排列, 为空则默认根据二维码id排序
     */
    private Boolean lastSubscribe;

    /**
     * 微信二维码类型, 0 临时码，1 永久码
     *
     * @see QrCodeTypeEnum
     */
    private Integer type;
}
