package cn.com.duiba.wechat.server.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wechat.server.api.dto.datacube.CumulateUserDTO;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 微信数据统计
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-10-10 16:24
 * @since 0.1.0
 **/
@AdvancedFeignClient
public interface RemoteDataCubeService {
    /**
     * 获取累计用户
     *
     * @param beginDate 开始日期
     * @param endDate   结束日期
     * @return 累计用户
     */
    List<CumulateUserDTO> getUserCumulate(@NotBlank(message = "开始日期不能为空") String beginDate
            , @NotBlank(message = "结束日期不能为空") String endDate);
}
