package cn.com.duiba.wechat.server.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wechat.server.api.dto.WxAppConfigDTO;
import cn.com.duiba.wechat.server.api.param.config.WxDomainDTO;

/**
 * 微信配置服务
 *
 * @author zouweixiang
 * @date 2021/11/29
 */
@AdvancedFeignClient
public interface RemoteWxAppService {

    /**
     * 得到默认的微信应用配置
     *
     * @return {@link WxAppConfigDTO}
     */
    WxAppConfigDTO getDefaultWxApp();

    /**
     * 获取域名
     *
     * @return {@link WxDomainDTO}
     */
    WxDomainDTO getDomain();
}
