package cn.com.duiba.wechat.server.api.constant;

import cn.com.duiba.wechat.server.api.constant.enums.PushScenesEnum;
import cn.com.duiba.wechat.server.api.dto.templatepush.TemplateParameterDTO;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;

import static cn.com.duiba.wechat.server.api.constant.enums.PushScenesEnum.TIMING;

/**
 * @author xuanhongjian
 */
@Slf4j
public class SceneParamConstants {

    /**
     * 存放每个场景的可用变量
     */
    private static final ImmutableMap<Integer, Map<String, String>> INNER_MAP;

    static {
        ImmutableMap.Builder<Integer, Map<String, String>> builder = ImmutableMap.builder();
        Map<String, String> prizeNotice = Maps.newHashMap();
        prizeNotice.put("{user}", "getUser");
        prizeNotice.put("{phone}", "getPhone");
        prizeNotice.put("{activity}", "getActivityName");
        prizeNotice.put("{award}", "getAwardName");
        prizeNotice.put("{award_time}", "getAwardTime");
        prizeNotice.put("{award_deadline}", "getAwardDeadline");
        builder.put(PushScenesEnum.PRIZE_NOTICE.getCode(), prizeNotice);
        Map<String, String> expiredNotice = Maps.newHashMap();
        expiredNotice.put("{user}", "getUser");
        expiredNotice.put("{phone}", "getPhone");
        expiredNotice.put("{activity}", "getActivityName");
        expiredNotice.put("{award}", "getAwardName");
        expiredNotice.put("{award_time}", "getAwardTime");
        expiredNotice.put("{award_deadline}", "getAwardDeadline");
        builder.put(PushScenesEnum.EXPIRED_NOTICE.getCode(), expiredNotice);
        Map<String, String> shipNotice = Maps.newHashMap();
        shipNotice.put("{user}", "getUser");
        shipNotice.put("{phone}", "getPhone");
        shipNotice.put("{activity}", "getActivityName");
        shipNotice.put("{award}", "getAwardName");
        shipNotice.put("{award_time}", "getAwardTime");
        shipNotice.put("{award_deadline}", "getAwardDeadline");
        shipNotice.put("{express_company}", "getExpressCompany");
        shipNotice.put("{express_num}", "getExpressNum");
        shipNotice.put("{order_id}", "getOrderId");
        shipNotice.put("{delivery_time}","getDeliveryTime");
        builder.put(PushScenesEnum.SHIP_NOTICE.getCode(), shipNotice);
        //定时任务提醒参数
        Map<String, String> timingNotice = Maps.newHashMap();
        timingNotice.put("{user}", "getUser");
        timingNotice.put("{phone}", "getPhone");
        builder.put(TIMING.getCode(), timingNotice);
        //入网审核通过
        Map<String, String> saleUserCheckPass = Maps.newHashMap();
        saleUserCheckPass.put("{user}", "getUser");
        saleUserCheckPass.put("{phone}", "getPhone");
        saleUserCheckPass.put("{audit_time}", "getAuditTime");
        saleUserCheckPass.put("{submit_time}", "getSubmitTime");
        saleUserCheckPass.put("{licence_number}", "getLicenceNumber");
        builder.put(PushScenesEnum.SALE_USER_CHECK_PASS.getCode(), saleUserCheckPass);
        //入网审核不通过
        Map<String, String> saleUserCheckUnPass = Maps.newHashMap();
        saleUserCheckUnPass.put("{user}", "getUser");
        saleUserCheckUnPass.put("{phone}", "getPhone");
        saleUserCheckUnPass.put("{audit_time}", "getAuditTime");
        saleUserCheckUnPass.put("{submit_time}", "getSubmitTime");
        saleUserCheckUnPass.put("{licence_number}", "getLicenceNumber");
        saleUserCheckUnPass.put("{refuse_reason}", "getRefuseReason");
        builder.put(PushScenesEnum.SALE_USER_CHECK_UN_PASS.getCode(), saleUserCheckUnPass);
        //专卖证申诉通过
        Map<String, String> saleUserAppealPass = Maps.newHashMap();
        saleUserAppealPass.put("{user}", "getUser");
        saleUserAppealPass.put("{phone}", "getPhone");
        saleUserAppealPass.put("{audit_time}", "getAuditTime");
        saleUserAppealPass.put("{submit_time}", "getSubmitTime");
        saleUserAppealPass.put("{licence_number}", "getLicenceNumber");
        builder.put(PushScenesEnum.SALE_USER_APPEAL_PASS.getCode(), saleUserAppealPass);
        //专卖证申诉失败
        Map<String, String> saleUserAppealUnPass = Maps.newHashMap();
        saleUserAppealUnPass.put("{user}", "getUser");
        saleUserAppealUnPass.put("{phone}", "getPhone");
        saleUserAppealUnPass.put("{audit_time}", "getAuditTime");
        saleUserAppealUnPass.put("{submit_time}", "getSubmitTime");
        saleUserAppealUnPass.put("{licence_number}", "getLicenceNumber");
        saleUserAppealUnPass.put("{refuse_reason}", "getRefuseReason");
        builder.put(PushScenesEnum.SALE_USER_APPEAL_UN_PASS.getCode(), saleUserAppealUnPass);
        //手机号被申诉
        Map<String, String> saleUserMobileUpdate = Maps.newHashMap();
        saleUserMobileUpdate.put("{user}", "getUser");
        saleUserMobileUpdate.put("{unbound_phone}", "getUnboundPhone");
        builder.put(PushScenesEnum.SALE_USER_MOBILE_CHECK.getCode(), saleUserMobileUpdate);

        //专卖证被解绑
        Map<String, String> saleCertificateUnBand = Maps.newHashMap();
        saleCertificateUnBand.put("{user}", "getUser");
        saleCertificateUnBand.put("{phone}", "getPhone");
        saleCertificateUnBand.put("{licence_number}", "getLicenceNumber");
        builder.put(PushScenesEnum.SALE_CERTIFICATE_NO_UN_BAND.getCode(), saleCertificateUnBand);

        // 获客活动-审核通过(业务员)
        Map<String, String> acquireAuditPass = Maps.newHashMap();
        acquireAuditPass.put("{user}", "getUser");
        acquireAuditPass.put("{phone}", "getPhone");
        acquireAuditPass.put("{audit_time}", "getAuditTime");
        acquireAuditPass.put("{submit_time}", "getSubmitTime");
        acquireAuditPass.put("{activity}", "getActivityName");
        builder.put(PushScenesEnum.TERMINAL_AUDIT_PASS.getCode(), acquireAuditPass);

        // 获客活动-审核不通过(业务员)
        Map<String, String> acquireAuditNotPass = Maps.newHashMap();
        acquireAuditNotPass.put("{user}", "getUser");
        acquireAuditNotPass.put("{phone}", "getPhone");
        acquireAuditNotPass.put("{audit_time}", "getAuditTime");
        acquireAuditNotPass.put("{submit_time}", "getSubmitTime");
        acquireAuditNotPass.put("{activity}", "getActivityName");
        builder.put(PushScenesEnum.TERMINAL_AUDIT_NOT_PASS.getCode(), acquireAuditNotPass);

        // 获客活动-参与通知(零售户)
        Map<String, String> retailerJoinAct = Maps.newHashMap();
        retailerJoinAct.put("{user}", "getUser");
        retailerJoinAct.put("{phone}", "getPhone");
        retailerJoinAct.put("{audit_time}", "getAuditTime");
        retailerJoinAct.put("{submit_time}", "getSubmitTime");
        retailerJoinAct.put("{licence_number}", "getLicenceNumber");
        retailerJoinAct.put("{activity}", "getActivityName");
        retailerJoinAct.put("{award}", "getAwardName");
        retailerJoinAct.put("{shop_name}", "getShopName");
        retailerJoinAct.put("{activity_time}", "getActivityTime");
        builder.put(PushScenesEnum.RETAILER_JOIN_ACT.getCode(), retailerJoinAct);

        // 获客活动-零售户可领取奖品
        Map<String, String> retailerCanReceive = Maps.newHashMap();
        retailerCanReceive.put("{user}", "getUser");
        retailerCanReceive.put("{phone}", "getPhone");
        retailerCanReceive.put("{audit_time}", "getAuditTime");
        retailerCanReceive.put("{submit_time}", "getSubmitTime");
        retailerCanReceive.put("{licence_number}", "getLicenceNumber");
        retailerCanReceive.put("{activity}", "getActivityName");
        retailerCanReceive.put("{award}", "getAwardName");
        retailerCanReceive.put("{shop_name}", "getShopName");
        builder.put(PushScenesEnum.RETAILER_CAN_RECEIVE.getCode(), retailerCanReceive);


        //陈列竞赛审核通过
        Map<String, String> displayCheckPass = Maps.newHashMap();
        displayCheckPass.put("{user}", "getUser");
        displayCheckPass.put("{phone}", "getPhone");
        displayCheckPass.put("{audit_time}", "getAuditTime");
        displayCheckPass.put("{submit_time}", "getSubmitTime");
        displayCheckPass.put("{activity}", "getActivityName");
        builder.put(PushScenesEnum.DISPLAY_CHECK_PASS.getCode(), displayCheckPass);
        //投票审核通过
        Map<String, String> voteCheckPass = Maps.newHashMap();
        voteCheckPass.put("{user}", "getUser");
        voteCheckPass.put("{phone}", "getPhone");
        voteCheckPass.put("{audit_time}", "getAuditTime");
        voteCheckPass.put("{submit_time}", "getSubmitTime");
        voteCheckPass.put("{activity}", "getActivityName");
        builder.put(PushScenesEnum.VOTE_CHEKCK_PASS.getCode(), voteCheckPass);
        //投票审核通过
        Map<String, String> voteCheckFail = Maps.newHashMap();
        voteCheckFail.put("{user}", "getUser");
        voteCheckFail.put("{phone}", "getPhone");
        voteCheckFail.put("{audit_time}", "getAuditTime");
        voteCheckFail.put("{submit_time}", "getSubmitTime");
        voteCheckFail.put("{activity}", "getActivityName");
        builder.put(PushScenesEnum.VOTE_CHEKCK_FAIL.getCode(), voteCheckFail);

        INNER_MAP = builder.build();
    }

    /**
     *
     * @param code 场景值
     * @param paramName 参数名称
     * @param dto 模版参数值
     * @return 实际值
     */
    public static String getValue(Integer code,String paramName,TemplateParameterDTO dto) {
        Map<String, String> map = INNER_MAP.get(code);
        if(MapUtils.isEmpty(map)){
            return paramName;
        }
        Class<?> aClass = dto.getClass();
        for (Map.Entry<String, String> entry:map.entrySet()) {
            String key = entry.getKey();
            if(paramName.contains(key)){
                try {
                    Method declaredMethod = aClass.getDeclaredMethod(entry.getValue());
                    Object invoke = declaredMethod.invoke(dto);
                    if (invoke != null) {
                        if (invoke instanceof Date) {
                            String value = DateFormatUtils
                                               .format((Date) invoke, "yyyy-MM-dd HH:mm:ss");
                            paramName = paramName.replaceAll(String.format("\\%s", key), value);
                        } else {
                            paramName = paramName.replaceAll(String.format("\\%s", key),
                                invoke.toString());
                        }
                    } else {
                        paramName = paramName.replaceAll(String.format("\\%s", key), "");
                    }
                }catch (Exception e){
                    log.error("替换用户变量异常",e);
                }
            }
        }
      return paramName;
    }
}
