 package cn.com.duiba.wechat.server.api.constant.enums;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import lombok.Getter;

/**
 * 群发任务类型
 *
 * @author xuanhongjian
 */
@Getter
public enum GroupSendTaskRangeEnum {

    /**
     * 1:全部，2:定向
     */
    ALL(1, "全部"),
    ORIENTATION(2, "定向");

    private static final ImmutableMap<Integer, GroupSendTaskRangeEnum> INNER_MAP;

    static {
        ImmutableMap.Builder<Integer, GroupSendTaskRangeEnum> builder = ImmutableMap.builder();
        for (GroupSendTaskRangeEnum item : GroupSendTaskRangeEnum.values()) {
            builder = builder.put(item.code, item);
        }
        INNER_MAP = builder.build();
    }


    private final Integer code;
    private final String desc;

    GroupSendTaskRangeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    public static GroupSendTaskRangeEnum getByCode(Integer termValue) {
        return Objects.isNull(termValue) ? null : INNER_MAP.get(termValue);
    }

}
