package cn.com.duiba.wechat.server.api.dto;

import lombok.Getter;
import lombok.Setter;

import java.util.Date;

/**
 * @author linzhou
 * @ClassName FileImportListVO.java
 * @createTime 2021年11月29日 11:12:00
 * @Description
 */
@Getter
@Setter
public class FileImportListDTO {

    /**
     * 主键id
     */
    private Long id;

    /**
     * 企业id
     */
    private Long tenantId;

    /**
     * 导入类型 1-员工导入 2-角色员工导入 3-标签员工关联
     */
    private Byte importType;


    /**
     * 上传文件名称
     */
    private String fileName;

    /**
     * 导入文件url
     */
    private String importFileUrl;

    /**
     * 导入总行数量
     */
    private Integer totalNum;

    /**
     * 导入成功数量
     */
    private Integer successNum = 0;

    /**
     * 导入失败数量
     */
    private Integer failNum = 0;

    /**
     * 导入失败文件url
     */
    private String failFileUrl;

    /**
     * 导入状态 0-处理完毕 1-处理中
     */
    private Byte state;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 操作人->企业管理员
     */
    private Long createdBy;
}
