package cn.com.duiba.wechat.server.api.dto.qrcode;

import cn.com.duiba.wechat.server.api.constant.enums.WxPushMsgTypeEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/4/8 16:20
 */
@Getter
@Setter
@ToString
public class AutoRespInfoDTO implements Serializable {

    /**
     * 推送类型
     * @see WxPushMsgTypeEnum#TEXT
     * @see WxPushMsgTypeEnum#IMAGE
     * @see WxPushMsgTypeEnum#NEWS
     * @see WxPushMsgTypeEnum#VOICE
     * @see WxPushMsgTypeEnum#VIDEO
     */
    private WxPushMsgTypeEnum pushMsgType;

    /**
     * 文本内容
     * <p>
     *  pushMsgType 为 TEXT 必填
     * </p>
     */
    private String content;

    /**
     * 素材id
     * <p>
     *  pushMsgType 为 IMAGE、VOICE、VIDEO 必填
     * </p>
     */
    private String mediaId;

    /**
     * 视频信息
     * <p>
     *  pushMsgType 为 VIDEO 选填
     * </p>
     */
    private String title;

    /**
     * 视频信息
     * <p>
     *  pushMsgType 为 VIDEO 选填
     * </p>
     */
    private String description;

    /**
     * 图文消息个数；当用户发送文本、图片、语音、视频、图文、地理位置这六种消息时，开发者只能回复1条图文消息；其余场景最多可回复8条图文消息
     * <p>
     *  pushMsgType 为 NEWS 必填
     * </p>
     */
    private Integer articleCount;

    /**
     * 富文本信息
     */
    private String richContent;

    /**
     * 图片链接
     * <p>
     *  pushMsgType 为 NEWS 必填
     * </p>
     */
    private String url;
}
