package cn.com.duiba.wechat.server.api.dto.templatepush;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ManualPushDTO implements Serializable {

    private static final long serialVersionUID = -7264584596891560446L;

    /**
     * 推送ID
     */
    private Long id;

    private String pushName;

    /**
     * 推送类型 1.立即推送 2.定时推送
     */
    private Integer pushType;

    /**
     *     1, "待开始"
     *     2, "已取消"
     *     3, "任务失败"
     *     4, "进行中"
     *     5,"等待微信回调完成"
     *     6, "任务完成"
     */
    private Integer statue;

    private Date pushDate;

    private Long successCount;

    private Long rejectCount;

    private Long failCount;

    private String createBy;

    private Date gmtCreate;

}
