package cn.com.duiba.wechat.server.api.enums;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 数据统计枚举
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/4/11 19:54
 */
@Getter
@AllArgsConstructor
public enum DataStaticsEnum implements IEnum<Integer> {

    /**
     *
     */
    SCAN(1, "扫码人数"),
    SUBSCRIBE(2, "关注人数"),
    RETAINED(3, "当日留存人数"),
    CANCEL(4, "当日取关人数"),
    RETAIN_PERCENT(5, "当日留存率")
    ;

    private final Integer code;
    private final String desc;

    @Override
    public Integer getDbCode() {
        return code;
    }
}
