package cn.com.duiba.wechat.server.api.enums;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.biz.tool.utils.Conditions;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import lombok.Getter;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/4/12 13:59
 */
@Getter
public enum RedisKeyEnum {

    /**
     *
     */
    CREATE_WX_QRCODE("创建微信二维码", "createWxQrcode:{}"),
    CREATE_SELF_QRCODE("创建自建二维码", "createSelfQrcode"),
    GENERATE_SELF_QRCODE("生成自建二维码", "generateSelfQrcode_{}", "父级二维码ID"),
    SCAN_SELF_QRCODE("扫描自建二维码", "scanSelfQrcode_{}_{}", "二维码ID", "微信openId")
    ;

    private final String desc;
    private final String template;
    private final String[] argsDesc;

    RedisKeyEnum(String desc, String template, String...argsDesc) {
        this.desc = desc;
        this.template = template;
        this.argsDesc = argsDesc;
    }

    /**
     * 拼接key
     */
    public static String getKey(RedisKeyEnum keyTemplate, Object... args) throws BizException {
        // 校验参数数量是否正确
        int count = StrUtil.count(keyTemplate.template, "{}");
        Conditions.expectTrue(ObjectUtil.equals(count, args.length), "参数数量缺失");
        return StrUtil.format("zhongyanWechatServer_" + keyTemplate.template, args);
    }
}
