package cn.com.duiba.wechat.server.api.param.qrcode;

import cn.com.duiba.wechat.server.api.enums.ScanOperateType;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author duiba
 */
@Data
public class RemoteScanFocusRecordCountParam implements Serializable {

    private Date startTime;

    private Date endTime;

    private Long  bizId;

    private List<Long> ids;


    private Integer bizType;

    /**
     * 操作类型，0 扫码，1 扫码且关注
     * @see ScanOperateType
     */
    @NotNull(message = "操作类型不能为空")
    private Integer operateType;

}
