package cn.com.duiba.wechat.server.api.param.qrcode;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/4/12 11:25
 */
@Getter
@Setter
public class RemoteSelfQrcodeGenerateParam implements Serializable {

    /**
     * 生成数量
     */
    @NotNull(message = "请输入生成数量")
    @Max(value = 20000, message = "生成数量仅支持1至20000")
    @Min(value = 1, message = "生成数量仅支持1至20000")
    private Long num;

    /**
     * 父级自建二维码id
     */
    @NotNull(message = "父级自建二维码id不能为")
    private Long id;
}
