package cn.com.duiba.wechat.server.api.param.templatepush;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 创建自动推送配置
 *
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CreateAutoPushConfigParam implements Serializable {

    private static final long serialVersionUID = 8290747703548810177L;
    /**
     * 推送名称
     */
    @NotBlank(message = "推送名称不能为空")
    @Size(max = 20,message = "推送名称最大20个字符")
    private String pushName;

    /**
     * 推送场景 {@link cn.com.duiba.wechat.server.api.constant.enums.PushScenesEnum}
     */
    @NotNull(message = "推送场景不能空")
    private Integer pushScene;

    /**
     * 活动类型
     */
    private String activityTypes;

    /**
     * 模版ID
     */
    @NotBlank(message = "模版ID不能为空")
    private String templateId;

    /**
     * 模版名称
     */
    @NotBlank(message = "模版名称不能为空")
    private String templateName;

    /**
     * 参数配置
     */
    private JSONObject paramConfig;

    /**
     * 提前多少小时通知
     */
    private Integer warningHour;

    /**
     * 跳转url
     */
    private String url;

    /**
     * 变动相关人
     */
    private String modifiedBy;
}
