package cn.com.duiba.wechat.server.api.param.templatepush;

import cn.com.duiba.wolf.entity.PageRequest;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @author xuanhongjian
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class QueryPushRecordParam extends PageRequest {

    private static final long serialVersionUID = 8169209777832286839L;

    /**
     * 推送时间
     */
    private Date pushStartDate;
    private Date pushEndDate;

    /**
     * 推送名称
     */
    private String pushName;
    /**
     * 推送场景
     */
    private Integer pushScene;
    /**
     * openID
     */
    private String openId;
    /**
     * 推送状态 1:“成功”、2:“失败”、3:“拒收”
     */
    private Integer statue;

    /**
     * 手动推送任务ID
     */
    private Long taskId;
}
