/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wechat.server.api.constant;

import cn.com.duiba.wechat.server.api.constant.enums.PushScenesEnum;
import cn.com.duiba.wechat.server.api.dto.templatepush.TemplateParameterDTO;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SceneParamConstants {
    private static final Logger log = LoggerFactory.getLogger(SceneParamConstants.class);
    private static final ImmutableMap<Integer, Map<String, String>> INNER_MAP;

    public static String getValue(Integer code, String paramName, TemplateParameterDTO dto) {
        Map map = (Map)INNER_MAP.get((Object)code);
        if (MapUtils.isEmpty((Map)map)) {
            return paramName;
        }
        Class<?> aClass = dto.getClass();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            if (!paramName.contains(key)) continue;
            try {
                Method declaredMethod = aClass.getDeclaredMethod((String)entry.getValue(), new Class[0]);
                Object invoke = declaredMethod.invoke((Object)dto, new Object[0]);
                if (invoke != null) {
                    if (invoke instanceof Date) {
                        String value = DateFormatUtils.format((Date)((Date)invoke), (String)"yyyy-MM-dd HH:mm:ss");
                        paramName = paramName.replaceAll(String.format("\\%s", key), value);
                        continue;
                    }
                    paramName = paramName.replaceAll(String.format("\\%s", key), invoke.toString());
                    continue;
                }
                paramName = paramName.replaceAll(String.format("\\%s", key), "");
            }
            catch (Exception e) {
                log.error("\u66ff\u6362\u7528\u6237\u53d8\u91cf\u5f02\u5e38", (Throwable)e);
            }
        }
        return paramName;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashMap prizeNotice = Maps.newHashMap();
        prizeNotice.put("{user}", "getUser");
        prizeNotice.put("{phone}", "getPhone");
        prizeNotice.put("{activity}", "getActivityName");
        prizeNotice.put("{award}", "getAwardName");
        prizeNotice.put("{award_time}", "getAwardTime");
        prizeNotice.put("{award_deadline}", "getAwardDeadline");
        builder.put((Object)PushScenesEnum.PRIZE_NOTICE.getCode(), (Object)prizeNotice);
        HashMap expiredNotice = Maps.newHashMap();
        expiredNotice.put("{user}", "getUser");
        expiredNotice.put("{phone}", "getPhone");
        expiredNotice.put("{activity}", "getActivityName");
        expiredNotice.put("{award}", "getAwardName");
        expiredNotice.put("{award_time}", "getAwardTime");
        expiredNotice.put("{award_deadline}", "getAwardDeadline");
        builder.put((Object)PushScenesEnum.EXPIRED_NOTICE.getCode(), (Object)expiredNotice);
        HashMap shipNotice = Maps.newHashMap();
        shipNotice.put("{user}", "getUser");
        shipNotice.put("{phone}", "getPhone");
        shipNotice.put("{activity}", "getActivityName");
        shipNotice.put("{award}", "getAwardName");
        shipNotice.put("{award_time}", "getAwardTime");
        shipNotice.put("{award_deadline}", "getAwardDeadline");
        shipNotice.put("{express_company}", "getExpressCompany");
        shipNotice.put("{express_num}", "getExpressNum");
        shipNotice.put("{order_id}", "getOrderId");
        shipNotice.put("{delivery_time}", "getDeliveryTime");
        builder.put((Object)PushScenesEnum.SHIP_NOTICE.getCode(), (Object)shipNotice);
        HashMap timingNotice = Maps.newHashMap();
        timingNotice.put("{user}", "getUser");
        timingNotice.put("{phone}", "getPhone");
        builder.put((Object)PushScenesEnum.TIMING.getCode(), (Object)timingNotice);
        HashMap saleUserCheckPass = Maps.newHashMap();
        saleUserCheckPass.put("{user}", "getUser");
        saleUserCheckPass.put("{phone}", "getPhone");
        saleUserCheckPass.put("{audit_time}", "getAuditTime");
        saleUserCheckPass.put("{submit_time}", "getSubmitTime");
        saleUserCheckPass.put("{licence_number}", "getLicenceNumber");
        builder.put((Object)PushScenesEnum.SALE_USER_CHECK_PASS.getCode(), (Object)saleUserCheckPass);
        HashMap saleUserCheckUnPass = Maps.newHashMap();
        saleUserCheckUnPass.put("{user}", "getUser");
        saleUserCheckUnPass.put("{phone}", "getPhone");
        saleUserCheckUnPass.put("{audit_time}", "getAuditTime");
        saleUserCheckUnPass.put("{submit_time}", "getSubmitTime");
        saleUserCheckUnPass.put("{licence_number}", "getLicenceNumber");
        saleUserCheckUnPass.put("{refuse_reason}", "getRefuseReason");
        builder.put((Object)PushScenesEnum.SALE_USER_CHECK_UN_PASS.getCode(), (Object)saleUserCheckUnPass);
        HashMap saleUserAppealPass = Maps.newHashMap();
        saleUserAppealPass.put("{user}", "getUser");
        saleUserAppealPass.put("{phone}", "getPhone");
        saleUserAppealPass.put("{audit_time}", "getAuditTime");
        saleUserAppealPass.put("{submit_time}", "getSubmitTime");
        saleUserAppealPass.put("{licence_number}", "getLicenceNumber");
        builder.put((Object)PushScenesEnum.SALE_USER_APPEAL_PASS.getCode(), (Object)saleUserAppealPass);
        HashMap saleUserAppealUnPass = Maps.newHashMap();
        saleUserAppealUnPass.put("{user}", "getUser");
        saleUserAppealUnPass.put("{phone}", "getPhone");
        saleUserAppealUnPass.put("{audit_time}", "getAuditTime");
        saleUserAppealUnPass.put("{submit_time}", "getSubmitTime");
        saleUserAppealUnPass.put("{licence_number}", "getLicenceNumber");
        saleUserAppealUnPass.put("{refuse_reason}", "getRefuseReason");
        builder.put((Object)PushScenesEnum.SALE_USER_APPEAL_UN_PASS.getCode(), (Object)saleUserAppealUnPass);
        HashMap saleUserMobileUpdate = Maps.newHashMap();
        saleUserMobileUpdate.put("{user}", "getUser");
        saleUserMobileUpdate.put("{unbound_phone}", "getUnboundPhone");
        builder.put((Object)PushScenesEnum.SALE_USER_MOBILE_CHECK.getCode(), (Object)saleUserMobileUpdate);
        HashMap saleCertificateUnBand = Maps.newHashMap();
        saleCertificateUnBand.put("{user}", "getUser");
        saleCertificateUnBand.put("{phone}", "getPhone");
        saleCertificateUnBand.put("{licence_number}", "getLicenceNumber");
        builder.put((Object)PushScenesEnum.SALE_CERTIFICATE_NO_UN_BAND.getCode(), (Object)saleCertificateUnBand);
        HashMap acquireAuditPass = Maps.newHashMap();
        acquireAuditPass.put("{user}", "getUser");
        acquireAuditPass.put("{phone}", "getPhone");
        acquireAuditPass.put("{audit_time}", "getAuditTime");
        acquireAuditPass.put("{submit_time}", "getSubmitTime");
        acquireAuditPass.put("{activity}", "getActivityName");
        builder.put((Object)PushScenesEnum.TERMINAL_AUDIT_PASS.getCode(), (Object)acquireAuditPass);
        HashMap acquireAuditNotPass = Maps.newHashMap();
        acquireAuditNotPass.put("{user}", "getUser");
        acquireAuditNotPass.put("{phone}", "getPhone");
        acquireAuditNotPass.put("{audit_time}", "getAuditTime");
        acquireAuditNotPass.put("{submit_time}", "getSubmitTime");
        acquireAuditNotPass.put("{activity}", "getActivityName");
        builder.put((Object)PushScenesEnum.TERMINAL_AUDIT_NOT_PASS.getCode(), (Object)acquireAuditNotPass);
        HashMap retailerJoinAct = Maps.newHashMap();
        retailerJoinAct.put("{user}", "getUser");
        retailerJoinAct.put("{phone}", "getPhone");
        retailerJoinAct.put("{audit_time}", "getAuditTime");
        retailerJoinAct.put("{submit_time}", "getSubmitTime");
        retailerJoinAct.put("{licence_number}", "getLicenceNumber");
        retailerJoinAct.put("{activity}", "getActivityName");
        retailerJoinAct.put("{award}", "getAwardName");
        retailerJoinAct.put("{shop_name}", "getShopName");
        retailerJoinAct.put("{activity_time}", "getActivityTime");
        builder.put((Object)PushScenesEnum.RETAILER_JOIN_ACT.getCode(), (Object)retailerJoinAct);
        HashMap retailerCanReceive = Maps.newHashMap();
        retailerCanReceive.put("{user}", "getUser");
        retailerCanReceive.put("{phone}", "getPhone");
        retailerCanReceive.put("{audit_time}", "getAuditTime");
        retailerCanReceive.put("{submit_time}", "getSubmitTime");
        retailerCanReceive.put("{licence_number}", "getLicenceNumber");
        retailerCanReceive.put("{activity}", "getActivityName");
        retailerCanReceive.put("{award}", "getAwardName");
        retailerCanReceive.put("{shop_name}", "getShopName");
        builder.put((Object)PushScenesEnum.RETAILER_CAN_RECEIVE.getCode(), (Object)retailerCanReceive);
        HashMap displayCheckPass = Maps.newHashMap();
        displayCheckPass.put("{user}", "getUser");
        displayCheckPass.put("{phone}", "getPhone");
        displayCheckPass.put("{audit_time}", "getAuditTime");
        displayCheckPass.put("{submit_time}", "getSubmitTime");
        displayCheckPass.put("{activity}", "getActivityName");
        builder.put((Object)PushScenesEnum.DISPLAY_CHECK_PASS.getCode(), (Object)displayCheckPass);
        HashMap voteCheckPass = Maps.newHashMap();
        voteCheckPass.put("{user}", "getUser");
        voteCheckPass.put("{phone}", "getPhone");
        voteCheckPass.put("{audit_time}", "getAuditTime");
        voteCheckPass.put("{submit_time}", "getSubmitTime");
        voteCheckPass.put("{activity}", "getActivityName");
        builder.put((Object)PushScenesEnum.VOTE_CHEKCK_PASS.getCode(), (Object)voteCheckPass);
        HashMap voteCheckFail = Maps.newHashMap();
        voteCheckFail.put("{user}", "getUser");
        voteCheckFail.put("{phone}", "getPhone");
        voteCheckFail.put("{audit_time}", "getAuditTime");
        voteCheckFail.put("{submit_time}", "getSubmitTime");
        voteCheckFail.put("{activity}", "getActivityName");
        builder.put((Object)PushScenesEnum.VOTE_CHEKCK_FAIL.getCode(), (Object)voteCheckFail);
        INNER_MAP = builder.build();
    }
}

