/*
 * Decompiled with CFR 0.152.
 */
package com.uop.sdk;

import com.uop.sdk.EncryptType;
import com.uop.sdk.FileItem;
import com.uop.sdk.FopApiException;
import com.uop.sdk.FopClient;
import com.uop.sdk.FopOauthEncrypt;
import com.uop.sdk.FopParser;
import com.uop.sdk.FopRequest;
import com.uop.sdk.FopResponse;
import com.uop.sdk.FopUploadRequest;
import com.uop.sdk.ResponseEncryptItem;
import com.uop.sdk.SignItem;
import com.uop.sdk.SignType;
import com.uop.sdk.internal.parser.json.ObjectJsonParser;
import com.uop.sdk.internal.parser.xml.ObjectXmlParser;
import com.uop.sdk.internal.util.FopEncrypt;
import com.uop.sdk.internal.util.FopHashMap;
import com.uop.sdk.internal.util.FopLogger;
import com.uop.sdk.internal.util.FopSignature;
import com.uop.sdk.internal.util.FopUtils;
import com.uop.sdk.internal.util.RequestParametersHolder;
import com.uop.sdk.internal.util.StringUtils;
import com.uop.sdk.internal.util.WebUtils;
import com.uop.sdk.internal.util.json.JSONWriter;
import com.uop.sdk.uop.request.UopRequest;
import java.io.IOException;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class DefaultFormClient
implements FopClient {
    private String serverUrl;
    private String appId;
    private String privateKey;
    private String prodCode;
    private String format = "json";
    private SignType signType = SignType.RSA2;
    private String encryptType = EncryptType.AES.getValue();
    private String encryptKey;
    private String FopPublicKey;
    private boolean isBodyEncrypt;
    private FopOauthEncrypt fopOauthEncrypt;
    private long oauthEncryptGetTime;
    private String charset;
    private int connectTimeout = 3000;
    private int readTimeout = 15000;
    private String proxyHost;
    private int proxyPort;

    public DefaultFormClient(String serverUrl, String appId, String privateKey) {
        this.serverUrl = serverUrl;
        this.appId = appId;
        this.privateKey = privateKey;
    }

    public DefaultFormClient(String serverUrl, String appId, String privateKey, String format) {
        this(serverUrl, appId, privateKey);
        this.format = format;
    }

    public DefaultFormClient(String serverUrl, String appId, String privateKey, String format, String charset) {
        this(serverUrl, appId, privateKey, format);
        this.charset = charset;
    }

    public DefaultFormClient(String serverUrl, String appId, String privateKey, String format, String charset, String FopPublicKey) {
        this(serverUrl, appId, privateKey, format, charset);
        this.FopPublicKey = FopPublicKey;
    }

    public DefaultFormClient(String serverUrl, String appId, String privateKey, String format, String charset, String FopPublicKey, SignType signType) {
        this(serverUrl, appId, privateKey, format, charset, FopPublicKey);
        this.signType = signType;
    }

    public DefaultFormClient(String serverUrl, String appId, String privateKey, String format, String charset, String FopPublicKey, SignType signType, String proxyHost, int proxyPort) {
        this(serverUrl, appId, privateKey, format, charset, FopPublicKey, signType);
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public DefaultFormClient(String serverUrl, String appId, String privateKey, String format, String charset, String FopPublicKey, SignType signType, String encryptKey, String encryptType) {
        this(serverUrl, appId, privateKey, format, charset, FopPublicKey, signType);
        this.encryptKey = encryptKey;
        this.encryptType = encryptType;
    }

    public static Builder builder(String serverUrl, String appId, String privateKey) {
        return new Builder(serverUrl, appId, privateKey);
    }

    @Override
    public <T extends FopResponse> T execute(FopRequest<T> request) throws FopApiException {
        return this.execute(request, null);
    }

    @Override
    public <T extends FopResponse> T execute(FopRequest<T> request, String accessToken) throws FopApiException {
        return this.execute(request, accessToken, null);
    }

    @Override
    public <T extends FopResponse> T execute(FopRequest<T> request, String accessToken, String appAuthToken) throws FopApiException {
        FopParser<T> parser = null;
        parser = "xml".equals(this.format) ? new ObjectXmlParser<T>(request.getResponseClass()) : new ObjectJsonParser<T>(request.getResponseClass());
        return this._execute(request, parser, accessToken, appAuthToken);
    }

    @Override
    public <T extends FopResponse> T pageExecute(FopRequest<T> request) throws FopApiException {
        return this.pageExecute(request, "POST");
    }

    @Override
    public <T extends FopResponse> T pageExecute(FopRequest<T> request, String httpMethod) throws FopApiException {
        RequestParametersHolder requestHolder = this.getRequestHolderWithSign(request, null, null);
        if (FopLogger.isBizDebugEnabled().booleanValue()) {
            FopLogger.logBizDebug(this.getRedirectUrl(requestHolder));
        }
        FopResponse rsp = null;
        try {
            Class<T> clazz = request.getResponseClass();
            rsp = (FopResponse)clazz.newInstance();
        }
        catch (InstantiationException e) {
            FopLogger.logBizError(e);
        }
        catch (IllegalAccessException e) {
            FopLogger.logBizError(e);
        }
        if ("GET".equalsIgnoreCase(httpMethod)) {
            rsp.setUopSdkBody(this.getRedirectUrl(requestHolder));
        } else {
            String baseUrl = this.getRequestUrl(requestHolder);
            rsp.setUopSdkBody(WebUtils.buildForm(baseUrl, requestHolder.getApplicationParams()));
        }
        return (T)rsp;
    }

    @Override
    public <T extends FopResponse> T sdkExecute(FopRequest<T> request) throws FopApiException {
        RequestParametersHolder requestHolder = this.getRequestHolderWithSign(request, null, null);
        if (FopLogger.isBizDebugEnabled().booleanValue()) {
            FopLogger.logBizDebug(this.getSdkParams(requestHolder));
        }
        FopResponse rsp = null;
        try {
            Class<T> clazz = request.getResponseClass();
            rsp = (FopResponse)clazz.newInstance();
        }
        catch (InstantiationException e) {
            FopLogger.logBizError(e);
        }
        catch (IllegalAccessException e) {
            FopLogger.logBizError(e);
        }
        rsp.setUopSdkBody(this.getSdkParams(requestHolder));
        return (T)rsp;
    }

    @Override
    public <TR extends FopResponse, T extends FopRequest<TR>> TR parseAppSyncResult(Map<String, String> result, Class<T> requsetClazz) throws FopApiException {
        FopResponse tRsp = null;
        String rsp = result.get("result");
        try {
            FopRequest request = (FopRequest)requsetClazz.newInstance();
            Class responseClazz = request.getResponseClass();
            if (StringUtils.isEmpty(rsp)) {
                tRsp = (FopResponse)responseClazz.newInstance();
                tRsp.setUopCode("20000");
                tRsp.setBizCode("ACQ.SYSTEM_ERROR");
                tRsp.setBizMsg(result.get("memo"));
            } else {
                FopParser parser = null;
                parser = "xml".equals(this.format) ? new ObjectXmlParser(responseClazz) : new ObjectJsonParser(responseClazz);
                tRsp = parser.parse(rsp);
                tRsp.setUopSdkBody(rsp);
                this.checkResponseSign(request, parser, rsp, tRsp.isUopSuccess());
                if (!tRsp.isUopSuccess()) {
                    FopLogger.logBizError(rsp);
                }
            }
        }
        catch (RuntimeException e) {
            FopLogger.logBizError(rsp);
            throw e;
        }
        catch (FopApiException e) {
            FopLogger.logBizError(rsp);
            throw new FopApiException(e);
        }
        catch (InstantiationException e) {
            FopLogger.logBizError(rsp);
            throw new FopApiException(e);
        }
        catch (IllegalAccessException e) {
            FopLogger.logBizError(rsp);
            throw new FopApiException(e);
        }
        return (TR)tRsp;
    }

    private <T extends FopResponse> RequestParametersHolder getRequestHolderWithSign(FopRequest<?> request, String accessToken, String appAuthToken) throws FopApiException {
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        FopHashMap appParams = new FopHashMap((Map<? extends String, ? extends String>)request.getTextParams());
        try {
            if (request.getClass().getMethod("getBizContent", new Class[0]) != null && StringUtils.isEmpty((String)appParams.get("uop_data")) && request.getBizModel() != null) {
                appParams.put("uop_data", new JSONWriter().write(request.getBizModel(), true));
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
            FopLogger.logBizError(e);
        }
        if (request.isNeedEncrypt()) {
            if (StringUtils.isEmpty((String)appParams.get("uop_data"))) {
                throw new FopApiException("\u5f53\u524dAPI\u4e0d\u652f\u6301\u52a0\u5bc6\u8bf7\u6c42");
            }
            if (!StringUtils.areNotEmpty(this.encryptKey, this.encryptType)) {
                throw new FopApiException("API\u8bf7\u6c42\u8981\u6c42\u52a0\u5bc6\uff0c\u5219\u5fc5\u987b\u8bbe\u7f6e\u5bc6\u94a5\u548c\u5bc6\u94a5\u7c7b\u578b\uff1aencryptKey=" + this.encryptKey + ",encryptType=" + this.encryptType);
            }
            String encryptContent = FopEncrypt.encryptContent((String)appParams.get("uop_data"), this.encryptType, this.encryptKey, this.charset);
            appParams.put("uop_data", encryptContent);
        }
        if (!StringUtils.isEmpty(appAuthToken)) {
            appParams.put("app_auth_token", appAuthToken);
        }
        requestHolder.setApplicationParams(appParams);
        if (StringUtils.isEmpty(this.charset)) {
            this.charset = "UTF-8";
        }
        FopHashMap protocalMustParams = new FopHashMap();
        protocalMustParams.put("X-Uop-Api-Code", request.getApiMethodName());
        protocalMustParams.put("X-Uop-Version", request.getApiVersion());
        protocalMustParams.put("X-Uop-App-Id", this.appId);
        protocalMustParams.put("X-Uop-Sign-Type", (Object)this.signType);
        protocalMustParams.put("terminal_type", request.getTerminalType());
        protocalMustParams.put("terminal_info", request.getTerminalInfo());
        protocalMustParams.put("notify_url", request.getNotifyUrl());
        protocalMustParams.put("return_url", request.getReturnUrl());
        protocalMustParams.put("X-Uop-Charset", this.charset);
        if (request.isNeedEncrypt()) {
            protocalMustParams.put("encrypt_type", this.encryptType);
        }
        Long timestamp = System.currentTimeMillis();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        protocalMustParams.put("X-Uop-Timestamp", df.format(new Date(timestamp)));
        requestHolder.setProtocalMustParams(protocalMustParams);
        FopHashMap protocalOptParams = new FopHashMap();
        protocalOptParams.put("X-Uop-Format", this.format);
        protocalOptParams.put("X-Uop-Auth-Token", accessToken);
        protocalOptParams.put("Fop_sdk", "Fop-sdk-java-dynamicVersionNo");
        protocalOptParams.put("prod_code", request.getProdCode());
        requestHolder.setProtocalOptParams(protocalOptParams);
        if (null != this.signType) {
            String signContent = FopSignature.getSignatureContent(requestHolder);
            protocalMustParams.put("X-Uop-Signature", FopSignature.rsaSign(signContent, this.privateKey, this.charset, this.signType));
        } else {
            protocalMustParams.put("X-Uop-Signature", "");
        }
        FopHashMap signMap = new FopHashMap((Map<? extends String, ? extends String>)FopSignature.getSortedMap(requestHolder));
        requestHolder.setApplicationParams(signMap);
        return requestHolder;
    }

    private String getRequestUrl(RequestParametersHolder requestHolder) throws FopApiException {
        StringBuffer urlSb = new StringBuffer(this.serverUrl);
        try {
            String sysMustQuery = WebUtils.buildQuery(requestHolder.getProtocalMustParams(), this.charset);
            String sysOptQuery = WebUtils.buildQuery(requestHolder.getProtocalOptParams(), this.charset);
            urlSb.append("?");
            urlSb.append(sysMustQuery);
            if (sysOptQuery != null & sysOptQuery.length() > 0) {
                urlSb.append("&");
                urlSb.append(sysOptQuery);
            }
        }
        catch (IOException e) {
            throw new FopApiException(e);
        }
        return urlSb.toString();
    }

    private String getRedirectUrl(RequestParametersHolder requestHolder) throws FopApiException {
        StringBuffer urlSb = new StringBuffer(this.serverUrl);
        try {
            Map<String, String> sortedMap = FopSignature.getSortedMap(requestHolder);
            String sortedQuery = WebUtils.buildQuery(sortedMap, this.charset);
            urlSb.append("?");
            urlSb.append(sortedQuery);
        }
        catch (IOException e) {
            throw new FopApiException(e);
        }
        return urlSb.toString();
    }

    private String getSdkParams(RequestParametersHolder requestHolder) throws FopApiException {
        StringBuffer urlSb = new StringBuffer();
        try {
            Map<String, String> sortedMap = FopSignature.getSortedMap(requestHolder);
            String sortedQuery = WebUtils.buildQuery(sortedMap, this.charset);
            urlSb.append(sortedQuery);
        }
        catch (IOException e) {
            throw new FopApiException(e);
        }
        return urlSb.toString();
    }

    private <T extends FopResponse> T _execute(FopRequest<T> request, FopParser<T> parser, String authToken, String appAuthToken) throws FopApiException {
        Map<String, Object> rt = this.doPost(request, authToken, appAuthToken);
        if (rt == null) {
            return null;
        }
        FopResponse tRsp = null;
        try {
            ResponseEncryptItem responseItem = this.encryptResponse(request, rt, parser);
            tRsp = (FopResponse)parser.parse(responseItem.getRealContent());
            tRsp.setUopSdkBody(responseItem.getRealContent());
            this.checkResponseSign(request, parser, responseItem.getRespContent(), tRsp.isUopSuccess());
        }
        catch (RuntimeException e) {
            FopLogger.logBizError((String)rt.get("rsp"));
            throw e;
        }
        catch (FopApiException e) {
            FopLogger.logBizError((String)rt.get("rsp"));
            throw new FopApiException(e);
        }
        tRsp.setParams((FopHashMap)rt.get("textParams"));
        if (!tRsp.isUopSuccess()) {
            FopLogger.logErrorScene(rt, tRsp, "");
        }
        return (T)tRsp;
    }

    private <T extends FopResponse> Map<String, Object> doPost(FopRequest<T> request, String accessToken, String appAuthToken) throws FopApiException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        RequestParametersHolder requestHolder = this.getRequestHolderWithSign(request, accessToken, appAuthToken);
        String url = this.getRequestUrl(requestHolder);
        if (FopLogger.isBizDebugEnabled().booleanValue()) {
            FopLogger.logBizDebug(this.getRedirectUrl(requestHolder));
        }
        String rsp = null;
        try {
            if (request instanceof FopUploadRequest) {
                FopUploadRequest uRequest = (FopUploadRequest)request;
                Map<String, FileItem> fileParams = FopUtils.cleanupMap(uRequest.getFileParams());
                rsp = WebUtils.doPost(url, requestHolder.getApplicationParams(), fileParams, this.charset, this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort);
            } else {
                rsp = WebUtils.doPost(url, requestHolder.getApplicationParams(), this.charset, this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort);
            }
        }
        catch (IOException e) {
            throw new FopApiException(e);
        }
        result.put("rsp", rsp);
        result.put("textParams", requestHolder.getApplicationParams());
        result.put("protocalMustParams", requestHolder.getProtocalMustParams());
        result.put("protocalOptParams", requestHolder.getProtocalOptParams());
        result.put("url", url);
        return result;
    }

    private <T extends FopResponse> void checkResponseSign(FopRequest<T> request, FopParser<T> parser, String responseBody, boolean responseIsSucess) throws FopApiException {
        if (!StringUtils.isEmpty(this.FopPublicKey)) {
            boolean rsaCheckContent;
            SignItem signItem = parser.getSignItem(request, responseBody);
            if (signItem == null) {
                throw new FopApiException("sign check fail: Body is Empty!");
            }
            if ((responseIsSucess || !responseIsSucess && !StringUtils.isEmpty(signItem.getSign())) && !(rsaCheckContent = FopSignature.rsaCheck(signItem.getSignSourceDate(), signItem.getSign(), this.FopPublicKey, this.charset, this.signType))) {
                if (!StringUtils.isEmpty(signItem.getSignSourceDate()) && signItem.getSignSourceDate().contains("\\/")) {
                    String srouceData = signItem.getSignSourceDate().replace("\\/", "/");
                    boolean jsonCheck = FopSignature.rsaCheck(srouceData, signItem.getSign(), this.FopPublicKey, this.charset, this.signType);
                    if (!jsonCheck) {
                        throw new FopApiException("sign check fail: check Sign and Data Fail\uff01JSON also\uff01");
                    }
                } else {
                    throw new FopApiException("sign check fail: check Sign and Data Fail!");
                }
            }
        }
    }

    private <T extends FopResponse> ResponseEncryptItem encryptResponse(FopRequest<T> request, Map<String, Object> rt, FopParser<T> parser) throws FopApiException {
        String responseBody = (String)rt.get("rsp");
        String realBody = null;
        realBody = request.isNeedEncrypt() ? parser.encryptSourceData(request, responseBody, this.format, this.encryptType, this.encryptKey, this.charset) : (String)rt.get("rsp");
        return new ResponseEncryptItem(responseBody, realBody);
    }

    @Override
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    void setAppId(String appId) {
        this.appId = appId;
    }

    @Override
    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    void setProdCode(String prodCode) {
        this.prodCode = prodCode;
    }

    void setFormat(String format) {
        this.format = format;
    }

    void setSignType(SignType signType) {
        this.signType = signType;
    }

    void setEncryptType(String encryptType) {
        this.encryptType = encryptType;
    }

    @Override
    public void setEncryptKey(String encryptKey) {
        this.encryptKey = encryptKey;
    }

    void setFopPublicKey(String FopPublicKey) {
        this.FopPublicKey = FopPublicKey;
    }

    void setCharset(String charset) {
        this.charset = charset;
    }

    void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    @Override
    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    @Override
    public String uopExecute(UopRequest request) throws FopApiException {
        return null;
    }

    static {
        Security.setProperty("jdk.certpath.disabledAlgorithms", "");
    }

    public static class Builder {
        private DefaultFormClient client;

        Builder(String serverUrl, String appId, String privateKey) {
            this.client = new DefaultFormClient(serverUrl, appId, privateKey);
        }

        public DefaultFormClient build() {
            return this.client;
        }

        public Builder prodCode(String prodCode) {
            this.client.setProdCode(prodCode);
            return this;
        }

        public Builder format(String format) {
            this.client.setFormat(format);
            return this;
        }

        public Builder signType(SignType signType) {
            this.client.setSignType(signType);
            return this;
        }

        public Builder encryptType(String encryptType) {
            this.client.setEncryptType(encryptType);
            return this;
        }

        public Builder encryptKey(String encryptKey) {
            this.client.setEncryptKey(encryptKey);
            return this;
        }

        public Builder FopPublicKey(String FopPublicKey) {
            this.client.setFopPublicKey(FopPublicKey);
            return this;
        }

        public Builder charset(String charset) {
            this.client.setCharset(charset);
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.client.setConnectTimeout(connectTimeout);
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.client.setReadTimeout(readTimeout);
            return this;
        }

        public Builder proxyHost(String proxyHost) {
            this.client.setProxyHost(proxyHost);
            return this;
        }

        public Builder proxyPort(int proxyPort) {
            this.client.setProxyPort(proxyPort);
            return this;
        }
    }
}

