/*
 * Decompiled with CFR 0.152.
 */
package com.uop.sdk.internal.util;

import com.uop.sdk.internal.util.Base64;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public class CertUtil {
    public static PrivateKey getPriKey(KeyStore keyStore, String password) {
        try {
            String keyAlias;
            Enumeration<String> aliasenum = keyStore.aliases();
            if (aliasenum.hasMoreElements() && keyStore.isKeyEntry(keyAlias = aliasenum.nextElement())) {
                PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, password.toCharArray());
                return privateKey;
            }
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (UnrecoverableKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static PublicKey getPubKey(KeyStore keyStore) {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements() && keyStore.isKeyEntry(keyAlias = aliasenum.nextElement())) {
                X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(keyAlias);
                PublicKey publicKey = x509Certificate.getPublicKey();
                return publicKey;
            }
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeyStore(String pfxkeyfile, String password) {
        FileInputStream fis = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            fis = new FileInputStream(pfxkeyfile);
            char[] nPassword = password.toCharArray();
            if (null != keyStore) {
                keyStore.load(fis, nPassword);
            }
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static PublicKey loadPubkey(String pubkeyfile) {
        CertificateFactory cf = null;
        FileInputStream in = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
            in = new FileInputStream(pubkeyfile);
            X509Certificate validateCert = (X509Certificate)cf.generateCertificate(in);
            return validateCert.getPublicKey();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getPubKeyStr(String pubKeyFile) {
        PublicKey publicKey1 = CertUtil.loadPubkey(pubKeyFile);
        return Base64.getEncoder().encodeToString(publicKey1.getEncoded());
    }

    public static String getPriKeyStr(String priKeyFile, String pwd) {
        KeyStore keyStore = CertUtil.loadKeyStore(priKeyFile, pwd);
        PrivateKey privateKey = CertUtil.getPriKey(keyStore, pwd);
        return Base64.getEncoder().encodeToString(privateKey.getEncoded());
    }

    public static String getPubKeyStr(String priKeyFile, String pwd) {
        KeyStore keyStore = CertUtil.loadKeyStore(priKeyFile, pwd);
        PublicKey priPublicKey = CertUtil.getPubKey(keyStore);
        return Base64.getEncoder().encodeToString(priPublicKey.getEncoded());
    }

    public static void main(String[] args) {
        String pfxkeyfile = "C:\\Users\\800P_maht01\\Desktop\\20200819\\apigateway.pfx";
        String password = "1";
        String pubkeyfile = "C:\\Users\\800P_maht01\\Desktop\\20200819\\apigateway.cer";
        System.out.println("\u7b7e\u540d\u79c1\u94a5-\u79c1\u94a5\u5185\u5bb9\uff1a" + CertUtil.getPriKeyStr(pfxkeyfile, password));
        System.out.println("\u7b7e\u540d\u79c1\u94a5-\u516c\u94a5\u5185\u5bb9\uff1a" + CertUtil.getPubKeyStr(pfxkeyfile, password));
        System.out.println("\u9a8c\u7b7e\u8bc1\u4e66-\u516c\u94a5\u5185\u5bb9\uff1a" + CertUtil.getPubKeyStr(pubkeyfile));
    }
}

