/*
 * Decompiled with CFR 0.152.
 */
package com.uop.sdk.internal.util;

import com.uop.sdk.FopApiException;
import com.uop.sdk.internal.util.Base64;
import com.uop.sdk.internal.util.SM4Utils;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class FopEncrypt {
    private static final String AES_ALG = "AES";
    private static final String SM4_ALG = "SM4";
    private static final String AES_CBC_PCK_ALG = "AES/CBC/PKCS5Padding";
    private static final byte[] AES_IV = FopEncrypt.initIv("AES/CBC/PKCS5Padding");

    public static String encryptContent(String content, String encryptType, String encryptKey, String charset) throws FopApiException {
        if (AES_ALG.equals(encryptType)) {
            return FopEncrypt.aesEncrypt(content, encryptKey, charset);
        }
        if (SM4_ALG.equals(encryptType)) {
            return SM4Utils.encryptData_ECB(encryptKey, content);
        }
        throw new FopApiException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u7b97\u6cd5\u7c7b\u578b\uff1aencrypeType=" + encryptType);
    }

    public static String decryptContent(String content, String encryptType, String encryptKey, String charset) throws FopApiException {
        if (AES_ALG.equals(encryptType)) {
            return FopEncrypt.aesDecrypt(content, encryptKey, charset);
        }
        if (SM4_ALG.equals(encryptType)) {
            String plainText = SM4Utils.decryptData_ECB(encryptKey, content);
            boolean verifyEcb = SM4Utils.verifyEcb(encryptKey, plainText, content);
            if (verifyEcb) {
                return plainText;
            }
            throw new FopApiException("SM4\u89e3\u5bc6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u79d8\u94a5\uff1aencrypeType=" + encryptType + " \u5bc6\u6587\uff1acontent" + content);
        }
        throw new FopApiException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u7b97\u6cd5\u7c7b\u578b\uff1aencrypeType=" + encryptType);
    }

    private static String aesEncrypt(String content, String aesKey, String charset) throws FopApiException {
        try {
            Cipher cipher = Cipher.getInstance(AES_CBC_PCK_ALG);
            IvParameterSpec iv = new IvParameterSpec(AES_IV);
            cipher.init(1, (Key)new SecretKeySpec(Base64.getDecoder().decode(aesKey.getBytes()), AES_ALG), iv);
            byte[] encryptBytes = cipher.doFinal(content.getBytes(charset));
            return Base64.getEncoder().encodeToString(encryptBytes);
        }
        catch (Exception e) {
            throw new FopApiException("AES\u52a0\u5bc6\u5931\u8d25\uff1aAescontent = " + content + "; charset = " + charset, e);
        }
    }

    private static String aesDecrypt(String content, String key, String charset) throws FopApiException {
        try {
            Cipher cipher = Cipher.getInstance(AES_CBC_PCK_ALG);
            IvParameterSpec iv = new IvParameterSpec(FopEncrypt.initIv(AES_CBC_PCK_ALG));
            cipher.init(2, (Key)new SecretKeySpec(Base64.getDecoder().decode(key.getBytes()), AES_ALG), iv);
            byte[] cleanBytes = cipher.doFinal(Base64.getDecoder().decode(content.getBytes()));
            return new String(cleanBytes, charset);
        }
        catch (Exception e) {
            throw new FopApiException("AES\u89e3\u5bc6\u5931\u8d25\uff1aAescontent = " + content + "; charset = " + charset, e);
        }
    }

    private static byte[] initIv(String fullAlg) {
        try {
            Cipher cipher = Cipher.getInstance(fullAlg);
            int blockSize = cipher.getBlockSize();
            byte[] iv = new byte[blockSize];
            for (int i = 0; i < blockSize; ++i) {
                iv[i] = 0;
            }
            return iv;
        }
        catch (Exception e) {
            int blockSize = 16;
            byte[] iv = new byte[blockSize];
            for (int i = 0; i < blockSize; ++i) {
                iv[i] = 0;
            }
            return iv;
        }
    }
}

