/*
 * Decompiled with CFR 0.152.
 */
package com.uop.sdk.internal.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.uop.sdk.FopApiException;
import com.uop.sdk.SignType;
import com.uop.sdk.internal.util.Base64;
import com.uop.sdk.internal.util.FopHashMap;
import com.uop.sdk.internal.util.RequestParametersHolder;
import com.uop.sdk.internal.util.SHA256Util;
import com.uop.sdk.internal.util.SM2Util;
import com.uop.sdk.internal.util.StreamUtil;
import com.uop.sdk.internal.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Cipher;

public class FopSignature {
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 256;

    public static String getSignatureContent(RequestParametersHolder requestHolder) {
        String contentStr = (String)requestHolder.getApplicationParams().get("uop_data");
        String content = Base64.getEncoder().encodeToString(SHA256Util.getSHA256Byte(contentStr));
        HashMap<String, String> signMap = new HashMap<String, String>();
        signMap.put("X-Uop-Api-Code", (String)requestHolder.getProtocalMustParams().get("X-Uop-Api-Code"));
        signMap.put("X-Uop-App-Id", (String)requestHolder.getProtocalMustParams().get("X-Uop-App-Id"));
        signMap.put("X-Uop-Unique-No", (String)requestHolder.getProtocalMustParams().get("X-Uop-Unique-No"));
        signMap.put("X-Uop-Timestamp", (String)requestHolder.getProtocalMustParams().get("X-Uop-Timestamp"));
        signMap.put("Body", content);
        return FopSignature.getSignContent(signMap);
    }

    public static String getBackSignatureContent(String contentStr, String X_Uop_Unique_No) {
        String content = Base64.getEncoder().encodeToString(SHA256Util.getSHA256Byte(contentStr));
        HashMap<String, String> signMap = new HashMap<String, String>();
        signMap.put("X-Uop-Unique-No", X_Uop_Unique_No);
        signMap.put("Body", content);
        return FopSignature.getSignContent(signMap);
    }

    public static Map<String, String> getSortedMap(RequestParametersHolder requestHolder) {
        FopHashMap protocalOptParams;
        FopHashMap protocalMustParams;
        TreeMap<String, String> sortedParams = new TreeMap<String, String>();
        FopHashMap appParams = requestHolder.getApplicationParams();
        if (appParams != null && appParams.size() > 0) {
            sortedParams.putAll(appParams);
        }
        if ((protocalMustParams = requestHolder.getProtocalMustParams()) != null && protocalMustParams.size() > 0) {
            sortedParams.putAll(protocalMustParams);
        }
        if ((protocalOptParams = requestHolder.getProtocalOptParams()) != null && protocalOptParams.size() > 0) {
            sortedParams.putAll(protocalOptParams);
        }
        return sortedParams;
    }

    public static Map<String, String> getSortedMap(JSONObject body) {
        TreeMap<String, String> sortedParams = new TreeMap<String, String>();
        Map params = (Map)JSONObject.parseObject((String)body.toJSONString(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        sortedParams.putAll(params);
        return sortedParams;
    }

    public static String getSignContent(Map<String, String> sortedParams) {
        StringBuffer content = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(sortedParams.keySet());
        Collections.sort(keys);
        int index = 0;
        for (int i = 0; i < keys.size(); ++i) {
            String value;
            String key = (String)keys.get(i);
            if (!StringUtils.areNotEmpty(key, value = String.valueOf(sortedParams.get(key)))) continue;
            content.append((index == 0 ? "" : "&") + key + "=" + value);
            ++index;
        }
        return content.toString();
    }

    public static String rsaSign(String content, String privateKey, String charset, SignType signType) throws FopApiException {
        switch (signType) {
            case RSA: {
                return FopSignature.rsaSign(content, privateKey, charset);
            }
            case RSA2: {
                return FopSignature.rsa256Sign(content, privateKey, charset);
            }
            case SM2: {
                return SM2Util.sign(content, privateKey);
            }
        }
        throw new FopApiException("Sign Type is Not Support : signType=" + (Object)((Object)signType));
    }

    public static String rsa256Sign(String content, String privateKey, String charset) throws FopApiException {
        try {
            PrivateKey priKey = FopSignature.getPrivateKeyFromPKCS8(SignType.RSA.getValue(), new ByteArrayInputStream(privateKey.getBytes()));
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initSign(priKey);
            if (StringUtils.isEmpty(charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            byte[] signed = signature.sign();
            return Base64.getEncoder().encodeToString(signed);
        }
        catch (Exception e) {
            throw new FopApiException("RSAcontent = " + content + "; charset = " + charset, e);
        }
    }

    public static String rsaSign(String content, String privateKey, String charset) throws FopApiException {
        try {
            PrivateKey priKey = FopSignature.getPrivateKeyFromPKCS8(SignType.RSA.getValue(), new ByteArrayInputStream(privateKey.getBytes()));
            Signature signature = Signature.getInstance("SHA1WithRSA");
            signature.initSign(priKey);
            if (StringUtils.isEmpty(charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            byte[] signed = signature.sign();
            return Base64.getEncoder().encodeToString(signed);
        }
        catch (InvalidKeySpecException ie) {
            throw new FopApiException("RSA\u79c1\u94a5\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6b63\u786e\u914d\u7f6e\u4e86PKCS8\u683c\u5f0f\u7684\u79c1\u94a5", ie);
        }
        catch (Exception e) {
            throw new FopApiException("RSAcontent = " + content + "; charset = " + charset, e);
        }
    }

    public static String rsaSign(Map<String, String> params, String privateKey, String charset) throws FopApiException {
        String signContent = FopSignature.getSignContent(params);
        return FopSignature.rsaSign(signContent, privateKey, charset);
    }

    public static PrivateKey getPrivateKeyFromPKCS8(String algorithm, InputStream ins) throws Exception {
        if (ins == null || StringUtils.isEmpty(algorithm)) {
            return null;
        }
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        byte[] encodedKey = StreamUtil.readText(ins).getBytes();
        encodedKey = Base64.getDecoder().decode(encodedKey);
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
    }

    public static String getSignCheckContentV1(Map<String, String> params) {
        if (params == null) {
            return null;
        }
        params.remove("X-Uop-Signature");
        params.remove("X-Uop-Sign-Type");
        StringBuilder content = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            content.append(i == 0 ? "" : "&").append(key).append("=").append(value);
        }
        return content.toString();
    }

    public static String getSignCheckContentV2(Map<String, String> params) {
        if (params == null) {
            return null;
        }
        params.remove("sign");
        StringBuilder content = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            content.append(i == 0 ? "" : "&").append(key).append("=").append(value);
        }
        return content.toString();
    }

    public static boolean rsaCheckV1(Map<String, String> params, String publicKey, String charset) throws FopApiException {
        String sign = params.get("X-Uop-Signature");
        String content = FopSignature.getSignCheckContentV1(params);
        return FopSignature.rsaCheckContent(content, sign, publicKey, charset);
    }

    public static boolean rsaCheckV1(Map<String, String> params, String publicKey, String charset, SignType signType) throws FopApiException {
        String sign = params.get("X-Uop-Signature");
        String content = FopSignature.getSignCheckContentV1(params);
        return FopSignature.rsaCheck(content, sign, publicKey, charset, signType);
    }

    public static boolean rsaCheckV2(Map<String, String> params, String publicKey, String charset) throws FopApiException {
        String sign = params.get("X-Uop-Signature");
        String content = FopSignature.getSignCheckContentV2(params);
        return FopSignature.rsaCheckContent(content, sign, publicKey, charset);
    }

    public static boolean rsaCheckV2(Map<String, String> params, String publicKey, String charset, SignType signType) throws FopApiException {
        String sign = params.get("X-Uop-Signature");
        String content = FopSignature.getSignCheckContentV2(params);
        return FopSignature.rsaCheck(content, sign, publicKey, charset, signType);
    }

    public static boolean rsaCheck(String content, String sign, String publicKey, String charset, SignType signType) throws FopApiException {
        switch (signType) {
            case RSA: {
                return FopSignature.rsaCheckContent(content, sign, publicKey, charset);
            }
            case RSA2: {
                return FopSignature.rsa256CheckContent(content, sign, publicKey, charset);
            }
            case SM2: {
                return SM2Util.check(content, sign, publicKey);
            }
        }
        throw new FopApiException("Sign Type is Not Support : signType=" + (Object)((Object)signType));
    }

    public static boolean rsa256CheckContent(String content, String sign, String publicKey, String charset) throws FopApiException {
        try {
            PublicKey pubKey = FopSignature.getPublicKeyFromX509(SignType.RSA.getValue(), new ByteArrayInputStream(publicKey.getBytes()));
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initVerify(pubKey);
            if (StringUtils.isEmpty(charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            return signature.verify(Base64.getDecoder().decode(sign.getBytes()));
        }
        catch (Exception e) {
            throw new FopApiException("RSAcontent = " + content + ",sign=" + sign + ",charset = " + charset, e);
        }
    }

    public static boolean rsaCheckContent(String content, String sign, String publicKey, String charset) throws FopApiException {
        try {
            PublicKey pubKey = FopSignature.getPublicKeyFromX509(SignType.RSA.getValue(), new ByteArrayInputStream(publicKey.getBytes()));
            Signature signature = Signature.getInstance("SHA1WithRSA");
            signature.initVerify(pubKey);
            if (StringUtils.isEmpty(charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            return signature.verify(Base64.getDecoder().decode(sign.getBytes()));
        }
        catch (Exception e) {
            throw new FopApiException("RSAcontent = " + content + ",sign=" + sign + ",charset = " + charset, e);
        }
    }

    public static PublicKey getPublicKeyFromX509(String algorithm, InputStream ins) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        StringWriter writer = new StringWriter();
        StreamUtil.io(new InputStreamReader(ins), writer);
        byte[] encodedKey = writer.toString().getBytes();
        encodedKey = Base64.getDecoder().decode(encodedKey);
        return keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
    }

    public static String checkSignAndDecrypt(Map<String, String> params, String fopPublicKey, String cusPrivateKey, boolean isCheckSign, boolean isDecrypt) throws FopApiException {
        String charset = params.get("charset");
        String bizContent = params.get("biz_content");
        if (isCheckSign && !FopSignature.rsaCheckV2(params, fopPublicKey, charset)) {
            throw new FopApiException("rsaCheck failure:rsaParams=" + params);
        }
        if (isDecrypt) {
            return FopSignature.rsaDecrypt(bizContent, cusPrivateKey, charset);
        }
        return bizContent;
    }

    public static String checkSignAndDecrypt(Map<String, String> params, String fopPublicKey, String cusPrivateKey, boolean isCheckSign, boolean isDecrypt, SignType signType) throws FopApiException {
        String charset = params.get("charset");
        String bizContent = params.get("biz_content");
        if (isCheckSign && !FopSignature.rsaCheckV2(params, fopPublicKey, charset, signType)) {
            throw new FopApiException("rsaCheck failure:rsaParams=" + params);
        }
        if (isDecrypt) {
            return FopSignature.rsaDecrypt(bizContent, cusPrivateKey, charset);
        }
        return bizContent;
    }

    public static String encryptAndSign(String bizContent, String fopPublicKey, String cusPrivateKey, String charset, boolean isEncrypt, boolean isSign) throws FopApiException {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty(charset)) {
            charset = "GBK";
        }
        sb.append("<?xml version=\"1.0\" encoding=\"").append(charset).append("\"?>");
        if (isEncrypt) {
            sb.append("<Fop>");
            String encrypted = FopSignature.rsaEncrypt(bizContent, fopPublicKey, charset);
            sb.append("<response>").append(encrypted).append("</response>");
            sb.append("<encryption_type>RSA</encryption_type>");
            if (isSign) {
                String sign = FopSignature.rsaSign(encrypted, cusPrivateKey, charset);
                sb.append("<sign>").append(sign).append("</sign>");
                sb.append("<sign_type>RSA</sign_type>");
            }
            sb.append("</Fop>");
        } else if (isSign) {
            sb.append("<Fop>");
            sb.append("<response>").append(bizContent).append("</response>");
            String sign = FopSignature.rsaSign(bizContent, cusPrivateKey, charset);
            sb.append("<sign>").append(sign).append("</sign>");
            sb.append("<sign_type>RSA</sign_type>");
            sb.append("</Fop>");
        } else {
            sb.append(bizContent);
        }
        return sb.toString();
    }

    public static String encryptAndSign(String bizContent, String fopPublicKey, String cusPrivateKey, String charset, boolean isEncrypt, boolean isSign, SignType signType) throws FopApiException {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty(charset)) {
            charset = "GBK";
        }
        sb.append("<?xml version=\"1.0\" encoding=\"").append(charset).append("\"?>");
        if (isEncrypt) {
            sb.append("<Fop>");
            String encrypted = FopSignature.rsaEncrypt(bizContent, fopPublicKey, charset);
            sb.append("<response>").append(encrypted).append("</response>");
            sb.append("<encryption_type>RSA</encryption_type>");
            if (isSign) {
                String sign = FopSignature.rsaSign(encrypted, cusPrivateKey, charset, signType);
                sb.append("<sign>").append(sign).append("</sign>");
                sb.append("<sign_type>");
                sb.append((Object)signType);
                sb.append("</sign_type>");
            }
            sb.append("</Fop>");
        } else if (isSign) {
            sb.append("<Fop>");
            sb.append("<response>").append(bizContent).append("</response>");
            String sign = FopSignature.rsaSign(bizContent, cusPrivateKey, charset, signType);
            sb.append("<sign>").append(sign).append("</sign>");
            sb.append("<sign_type>");
            sb.append((Object)signType);
            sb.append("</sign_type>");
            sb.append("</Fop>");
        } else {
            sb.append(bizContent);
        }
        return sb.toString();
    }

    public static String rsaEncrypt(String content, String publicKey, String charset) throws FopApiException {
        try {
            PublicKey pubKey = FopSignature.getPublicKeyFromX509(SignType.RSA.getValue(), new ByteArrayInputStream(publicKey.getBytes()));
            Cipher cipher = Cipher.getInstance(SignType.RSA.getValue());
            cipher.init(1, pubKey);
            byte[] data = Base64.getDecoder().decode(content);
            int inputLen = data.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
            byte[] encryptedData = Base64.getEncoder().encode(out.toByteArray());
            out.close();
            return StringUtils.isEmpty(charset) ? new String(encryptedData) : new String(encryptedData, charset);
        }
        catch (Exception e) {
            throw new FopApiException("EncryptContent = " + content + ",charset = " + charset, e);
        }
    }

    public static String rsaDecrypt(String content, String privateKey, String charset) throws FopApiException {
        try {
            PrivateKey priKey = FopSignature.getPrivateKeyFromPKCS8(SignType.RSA.getValue(), new ByteArrayInputStream(privateKey.getBytes()));
            Cipher cipher = Cipher.getInstance(SignType.RSA.getValue());
            cipher.init(2, priKey);
            byte[] encryptedData = StringUtils.isEmpty(charset) ? Base64.getDecoder().decode(content.getBytes()) : Base64.getDecoder().decode(content.getBytes(charset));
            int inputLen = encryptedData.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 256 ? cipher.doFinal(encryptedData, offSet, 256) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 256;
            }
            byte[] decryptedData = out.toByteArray();
            out.close();
            return Base64.getEncoder().encodeToString(decryptedData);
        }
        catch (Exception e) {
            throw new FopApiException("EncodeContent = " + content + ",charset = " + charset, e);
        }
    }
}

