/*
 * Decompiled with CFR 0.152.
 */
package com.uop.sdk.internal.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.uop.sdk.EncryptType;
import com.uop.sdk.FileItem;
import com.uop.sdk.FopApiException;
import com.uop.sdk.SignType;
import com.uop.sdk.internal.util.AESUtil;
import com.uop.sdk.internal.util.FopLogger;
import com.uop.sdk.internal.util.FopSignature;
import com.uop.sdk.internal.util.RequestParametersHolder;
import com.uop.sdk.internal.util.SM4Utils;
import com.uop.sdk.internal.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public abstract class FopWebUtils {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_GET = "GET";
    private static SSLContext ctx = null;
    private static HostnameVerifier verifier = null;
    private static SSLSocketFactory socketFactory = null;
    private static String encryptKey;

    private FopWebUtils() {
    }

    public static String doPost(String url, Map<String, String> params, boolean isBodyEncrypt, EncryptType encryptType, String encryptKey, String charset, int connectTimeout, int readTimeout, String proxyHost, int proxyPort, String privateKey, String reqUrl) throws IOException, JSONException, FopApiException {
        String ctype = "application/json;charset=" + charset;
        return FopWebUtils.doPost(url, ctype, params, isBodyEncrypt, encryptType, encryptKey, connectTimeout, readTimeout, proxyHost, proxyPort, charset, privateKey, reqUrl);
    }

    public static String uopDoPost(String url, Map<String, String> params, boolean isBodyEncrypt, EncryptType encryptType, String encryptKey, String charset, int connectTimeout, int readTimeout, String proxyHost, int proxyPort, String privateKey, String reqUrl, String fopPublicKey, SignType signType) throws IOException, JSONException, FopApiException {
        String ctype = "application/json;charset=" + charset;
        return FopWebUtils.uopDoPost(url, ctype, params, isBodyEncrypt, encryptType, encryptKey, connectTimeout, readTimeout, proxyHost, proxyPort, charset, privateKey, reqUrl, fopPublicKey, signType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, String ctype, Map<String, String> params, boolean isBodyEncrypt, EncryptType encryptType, String encryptKey, int connectTimeout, int readTimeout, String proxyHost, int proxyPort, String charset, String privateKey, String reqUrl) throws IOException, JSONException, FopApiException {
        String rsp;
        block31: {
            HttpURLConnection conn = null;
            OutputStream out = null;
            rsp = null;
            try {
                block30: {
                    Map<String, String> map;
                    String query = JSON.toJSONString((Object)params.get("uop_data"));
                    byte[] content = new byte[]{};
                    if (!StringUtils.isEmpty(query)) {
                        content = params.get("uop_data").getBytes(charset);
                    }
                    try {
                        conn = null;
                        conn = !StringUtils.isEmpty(proxyHost) ? FopWebUtils.getConnection(new URL(url + reqUrl), METHOD_POST, ctype, proxyHost, proxyPort) : FopWebUtils.getConnection(new URL(url + reqUrl), METHOD_POST, ctype);
                        conn.setConnectTimeout(connectTimeout);
                        conn.setReadTimeout(readTimeout);
                        conn.setRequestProperty("X-Uop-Api-Code", params.get("X-Uop-Api-Code"));
                        conn.setRequestProperty("X-Uop-App-Id", params.get("X-Uop-App-Id"));
                        if (StringUtils.areNotEmpty(params.get("X-Uop-Auth-Token"))) {
                            conn.setRequestProperty("X-Uop-Auth-Token", params.get("X-Uop-Auth-Token"));
                        }
                        conn.setRequestProperty("X-Uop-Signature", params.get("X-Uop-Signature"));
                        conn.setRequestProperty("X-Uop-Timestamp", params.get("X-Uop-Timestamp"));
                        conn.setRequestProperty("X-Uop-Unique-No", params.get("X-Uop-Unique-No"));
                        if (isBodyEncrypt) {
                            conn.setRequestProperty("X-Uop-Encrypted-Key", params.get("X-Uop-Encrypted-Key"));
                        }
                    }
                    catch (IOException e) {
                        Map<String, String> map2 = FopWebUtils.getParamsFromUrl(url);
                        FopLogger.logCommError((Exception)e, url, map2.get("app_key"), map2.get("X-Uop-Api-Code"), content);
                        throw e;
                    }
                    try {
                        out = conn.getOutputStream();
                        if (isBodyEncrypt) {
                            out.write(FopWebUtils.requestBodyEncrypt(params.get("X-Uop-App-Id"), url, content, encryptType, encryptKey));
                        } else {
                            out.write(content);
                        }
                        rsp = FopWebUtils.getResponseAsString(conn);
                        int responseCode = conn.getResponseCode();
                        if (200 == responseCode) break block30;
                        JSONObject JSONOb = null;
                        try {
                            JSONOb = JSONObject.parseObject((String)rsp);
                        }
                        catch (Exception e) {
                            throw new FopApiException(rsp);
                        }
                        JSONOb.put("notsu", (Object)"notsu");
                        String e = rsp = JSONObject.toJSONString((Object)JSONOb, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                        return e;
                    }
                    catch (IOException e) {
                        map = FopWebUtils.getParamsFromUrl(url);
                        FopLogger.logCommError((Exception)e, conn, map.get("app_key"), map.get("method"), content);
                        throw e;
                    }
                    catch (JSONException e) {
                        map = FopWebUtils.getParamsFromUrl(url);
                        FopLogger.logCommError((Exception)((Object)e), conn, map.get("app_key"), map.get("method"), rsp.getBytes());
                        throw e;
                    }
                }
                String X_Uop_Unique_No = conn.getHeaderField("X-Uop-Unique-No");
                String X_Uop_Signature = conn.getHeaderField("X-Uop-Signature");
                String X_Uop_Encrypted_Key = conn.getHeaderField("X-Uop-Encrypted-Key");
                if (StringUtils.isEmpty(X_Uop_Unique_No)) {
                    throw new FopApiException("\u8fd4\u56de\u6d41\u6c34\u53f7\u4e3a\u7a7a");
                }
                if (!params.get("X-Uop-Unique-No").equals(X_Uop_Unique_No)) {
                    throw new FopApiException("\u548c\u4e0a\u9001\u975e\u540c\u4e00\u7b14\u4ea4\u6613");
                }
                if (StringUtils.isEmpty(X_Uop_Signature)) {
                    throw new FopApiException("\u7b7e\u540d\u4e3a\u7a7a");
                }
                if (isBodyEncrypt && StringUtils.areNotEmpty(X_Uop_Encrypted_Key)) {
                    String backEncryptKey = "";
                    try {
                        backEncryptKey = FopSignature.rsaDecrypt(X_Uop_Encrypted_Key, privateKey, charset);
                    }
                    catch (FopApiException e1) {
                        throw new FopApiException("\u79d8\u94a5\u89e3\u5bc6\u5931\u8d25" + e1);
                    }
                    try {
                        rsp = FopWebUtils.responseBodyDencrypt(params.get("X-Uop-App-Id"), rsp, encryptType, backEncryptKey);
                        JSONObject JSONOb = JSONObject.parseObject((String)rsp);
                        JSONOb.put("uopResponseBody", (Object)rsp);
                        JSONOb.put("X-Uop-Unique-No", (Object)X_Uop_Unique_No);
                        JSONOb.put("X_Uop_Signature", (Object)X_Uop_Signature);
                        String signContent = FopSignature.getBackSignatureContent(rsp, X_Uop_Unique_No);
                        JSONOb.put("uop_signContent", (Object)signContent);
                        rsp = JSONObject.toJSONString((Object)JSONOb, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                        break block31;
                    }
                    catch (Exception e) {
                        JSONObject.parseObject((String)rsp);
                        String string = rsp;
                        if (out != null) {
                            out.close();
                        }
                        if (conn != null) {
                            conn.disconnect();
                        }
                        return string;
                    }
                }
                JSONObject JSONOb = JSONObject.parseObject((String)rsp);
                JSONOb.put("uopResponseBody", (Object)rsp);
                JSONOb.put("X-Uop-Unique-No", (Object)X_Uop_Unique_No);
                JSONOb.put("X_Uop_Signature", (Object)X_Uop_Signature);
                String signContent = FopSignature.getBackSignatureContent(rsp, X_Uop_Unique_No);
                JSONOb.put("uop_signContent", (Object)signContent);
                String string = rsp = JSONObject.toJSONString((Object)JSONOb, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                return string;
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        return rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uopDoPost(String url, String ctype, Map<String, String> params, boolean isBodyEncrypt, EncryptType encryptType, String encryptKey, int connectTimeout, int readTimeout, String proxyHost, int proxyPort, String charset, String privateKey, String reqUrl, String fopPublicKey, SignType signType) throws IOException, JSONException, FopApiException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            int responseCode;
            byte[] content;
            block26: {
                String query = JSON.toJSONString((Object)params.get("uop_data"));
                content = new byte[]{};
                if (!StringUtils.isEmpty(query)) {
                    content = params.get("uop_data").getBytes(charset);
                }
                try {
                    conn = null;
                    conn = !StringUtils.isEmpty(proxyHost) ? FopWebUtils.getConnection(new URL(url + reqUrl), METHOD_POST, ctype, proxyHost, proxyPort) : FopWebUtils.getConnection(new URL(url + reqUrl), METHOD_POST, ctype);
                    conn.setConnectTimeout(connectTimeout);
                    conn.setReadTimeout(readTimeout);
                    conn.setRequestProperty("X-Uop-Api-Code", params.get("X-Uop-Api-Code"));
                    conn.setRequestProperty("X-Uop-App-Id", params.get("X-Uop-App-Id"));
                    if (StringUtils.areNotEmpty(params.get("X-Uop-Auth-Token"))) {
                        conn.setRequestProperty("X-Uop-Auth-Token", params.get("X-Uop-Auth-Token"));
                    }
                    conn.setRequestProperty("X-Uop-Signature", params.get("X-Uop-Signature"));
                    conn.setRequestProperty("X-Uop-Timestamp", params.get("X-Uop-Timestamp"));
                    conn.setRequestProperty("X-Uop-Unique-No", params.get("X-Uop-Unique-No"));
                    if (isBodyEncrypt) {
                        conn.setRequestProperty("X-Uop-Encrypted-Key", params.get("X-Uop-Encrypted-Key"));
                    }
                }
                catch (IOException e) {
                    Map<String, String> map = FopWebUtils.getParamsFromUrl(url);
                    FopLogger.logCommError((Exception)e, url, map.get("app_key"), map.get("X-Uop-Api-Code"), content);
                    throw e;
                }
                out = conn.getOutputStream();
                if (isBodyEncrypt) {
                    out.write(FopWebUtils.requestBodyEncrypt(params.get("X-Uop-App-Id"), url, content, encryptType, encryptKey));
                } else {
                    out.write(content);
                }
                rsp = FopWebUtils.getResponseAsString(conn);
                responseCode = conn.getResponseCode();
                if (200 == responseCode) break block26;
                String map = rsp;
                return map;
            }
            try {
                String signContent;
                boolean rsaCheckContent;
                String X_Uop_Unique_No = conn.getHeaderField("X-Uop-Unique-No");
                String X_Uop_Signature = conn.getHeaderField("X-Uop-Signature");
                String X_Uop_Encrypted_Key = conn.getHeaderField("X-Uop-Encrypted-Key");
                if (StringUtils.isEmpty(X_Uop_Unique_No)) {
                    throw new FopApiException("\u8fd4\u56de\u6d41\u6c34\u53f7\u4e3a\u7a7a");
                }
                if (!params.get("X-Uop-Unique-No").equals(X_Uop_Unique_No)) {
                    throw new FopApiException("\u548c\u4e0a\u9001\u975e\u540c\u4e00\u7b14\u4ea4\u6613");
                }
                if (StringUtils.isEmpty(X_Uop_Signature)) {
                    throw new FopApiException("\u7b7e\u540d\u4e3a\u7a7a");
                }
                if (isBodyEncrypt && StringUtils.areNotEmpty(X_Uop_Encrypted_Key)) {
                    String backEncryptKey = "";
                    try {
                        backEncryptKey = FopSignature.rsaDecrypt(X_Uop_Encrypted_Key, privateKey, charset);
                    }
                    catch (FopApiException e1) {
                        throw new FopApiException("\u79d8\u94a5\u89e3\u5bc6\u5931\u8d25" + e1);
                    }
                    try {
                        rsp = FopWebUtils.responseBodyDencrypt(params.get("X-Uop-App-Id"), rsp, encryptType, backEncryptKey);
                    }
                    catch (Exception e) {
                        throw new FopApiException("\u89e3\u5bc6\u5931\u8d25" + e);
                    }
                }
                if (!(rsaCheckContent = FopSignature.rsaCheck(signContent = FopSignature.getBackSignatureContent(rsp, X_Uop_Unique_No), X_Uop_Signature, fopPublicKey, charset, signType))) {
                    throw new FopApiException("\u9a8c\u7b7e\u5931\u8d25!");
                }
                JSONObject JSONOb = new JSONObject();
                JSONOb.put("uopResponseBody", (Object)rsp);
                JSONOb.put("uopEncryptedKey", (Object)X_Uop_Encrypted_Key);
                JSONOb.put("uopSignature", (Object)X_Uop_Signature);
                JSONOb.put("httpResponseCode", (Object)responseCode);
                rsp = JSONObject.toJSONString((Object)JSONOb, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            }
            catch (IOException e) {
                Map<String, String> map = FopWebUtils.getParamsFromUrl(url);
                FopLogger.logCommError((Exception)e, conn, map.get("app_key"), map.get("method"), content);
                throw e;
            }
            catch (JSONException e) {
                Map<String, String> map = FopWebUtils.getParamsFromUrl(url);
                FopLogger.logCommError((Exception)((Object)e), conn, map.get("app_key"), map.get("method"), rsp.getBytes());
                throw e;
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static byte[] requestBodyEncrypt(String appId, String url, byte[] content, EncryptType encryptType, String encryptKey) {
        try {
            switch (encryptType) {
                case AES: {
                    return AESUtil.aesEncrypt(content, encryptKey);
                }
                case SM4: {
                    return SM4Utils.encryptData_CBC(content, encryptKey);
                }
            }
            return null;
        }
        catch (FopApiException e) {
            FopLogger.logCommError((Exception)e, url, appId, "", content);
            return new byte[]{0};
        }
    }

    private static String responseBodyDencrypt(String appId, String rsp, EncryptType encryptType, String encryptKey) throws FopApiException {
        switch (encryptType) {
            case AES: {
                return AESUtil.aesDecrypt(rsp, encryptKey);
            }
            case SM4: {
                return SM4Utils.decryptData_CBC(rsp, encryptKey);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, Map<String, String> params, Map<String, FileItem> fileParams, boolean isBodyEncrypt, EncryptType encryptType, String charset, int connectTimeout, int readTimeout, String proxyHost, int proxyPort, String privateKey, String reqUrl) throws IOException, JSONException, FopApiException {
        if (fileParams == null || fileParams.isEmpty()) {
            String ctype = "application/json;charset=" + charset;
            return FopWebUtils.doPost(url, ctype, params, isBodyEncrypt, encryptType, encryptKey, connectTimeout, readTimeout, proxyHost, proxyPort, charset, privateKey, reqUrl);
        }
        String boundary = System.currentTimeMillis() + "";
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            try {
                String ctype = "multipart/form-data;boundary=" + boundary + ";charset=" + charset;
                conn = null;
                conn = !StringUtils.isEmpty(proxyHost) ? FopWebUtils.getConnection(new URL(url), METHOD_POST, ctype, proxyHost, proxyPort) : FopWebUtils.getConnection(new URL(url), METHOD_POST, ctype);
                conn.setConnectTimeout(connectTimeout);
                conn.setReadTimeout(readTimeout);
            }
            catch (IOException e) {
                Map<String, String> map = FopWebUtils.getParamsFromUrl(url);
                FopLogger.logCommError((Exception)e, url, map.get("app_key"), map.get("method"), params);
                throw e;
            }
            try {
                out = conn.getOutputStream();
                byte[] entryBoundaryBytes = ("\r\n--" + boundary + "\r\n").getBytes(charset);
                Set<Map.Entry<String, String>> textEntrySet = params.entrySet();
                for (Map.Entry<String, String> textEntry : textEntrySet) {
                    byte[] textBytes = FopWebUtils.getTextEntry(textEntry.getKey(), textEntry.getValue(), charset);
                    out.write(entryBoundaryBytes);
                    out.write(textBytes);
                }
                Set<Map.Entry<String, FileItem>> fileEntrySet = fileParams.entrySet();
                for (Map.Entry<String, FileItem> fileEntry : fileEntrySet) {
                    FileItem fileItem = fileEntry.getValue();
                    byte[] fileBytes = FopWebUtils.getFileEntry(fileEntry.getKey(), fileItem.getFileName(), fileItem.getMimeType(), charset);
                    out.write(entryBoundaryBytes);
                    out.write(fileBytes);
                    out.write(fileItem.getContent());
                }
                byte[] endBoundaryBytes = ("\r\n--" + boundary + "--\r\n").getBytes(charset);
                out.write(endBoundaryBytes);
                rsp = FopWebUtils.getResponseAsString(conn);
            }
            catch (IOException e) {
                Map<String, String> map = FopWebUtils.getParamsFromUrl(url);
                FopLogger.logCommError((Exception)e, conn, map.get("app_key"), map.get("method"), params);
                throw e;
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static byte[] getTextEntry(String fieldName, String fieldValue, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\"\r\nContent-Type:text/plain\r\n\r\n");
        entry.append(fieldValue);
        return entry.toString().getBytes(charset);
    }

    private static byte[] getFileEntry(String fieldName, String fileName, String mimeType, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\";filename=\"");
        entry.append(fileName);
        entry.append("\"\r\nContent-Type:");
        entry.append(mimeType);
        entry.append("\r\n\r\n");
        return entry.toString().getBytes(charset);
    }

    public static String doGet(String url, Map<String, String> params) throws IOException {
        return FopWebUtils.doGet(url, params, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, Map<String, String> params, String charset) throws IOException {
        String rsp;
        HttpURLConnection conn = null;
        try {
            String ctype = "application/x-www-form-urlencoded;charset=" + charset;
            String query = FopWebUtils.buildQuery(params, charset);
            try {
                conn = FopWebUtils.getConnection(FopWebUtils.buildGetUrl(url, query), METHOD_GET, ctype);
            }
            catch (IOException e) {
                Map<String, String> map = FopWebUtils.getParamsFromUrl(url);
                FopLogger.logCommError((Exception)e, url, map.get("app_key"), map.get("method"), params);
                throw e;
            }
            try {
                rsp = FopWebUtils.getResponseAsString(conn);
            }
            catch (IOException e) {
                Map<String, String> map = FopWebUtils.getParamsFromUrl(url);
                FopLogger.logCommError((Exception)e, conn, map.get("app_key"), map.get("method"), params);
                throw e;
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static HttpURLConnection getConnection(URL url, String method, String ctype) throws IOException {
        return FopWebUtils.getConnection(url, method, ctype, null);
    }

    private static HttpURLConnection getConnection(URL url, String method, String ctype, String proxyHost, int proxyPort) throws IOException {
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
        return FopWebUtils.getConnection(url, method, ctype, proxy);
    }

    private static HttpURLConnection getConnection(URL url, String method, String ctype, Proxy proxy) throws IOException {
        HttpURLConnection conn = null;
        if ("https".equals(url.getProtocol())) {
            HttpsURLConnection connHttps = null;
            connHttps = proxy != null ? (HttpsURLConnection)url.openConnection(proxy) : (HttpsURLConnection)url.openConnection();
            connHttps.setSSLSocketFactory(socketFactory);
            connHttps.setHostnameVerifier(verifier);
            conn = connHttps;
        } else {
            conn = null;
            conn = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "text/xml,text/javascript,text/html");
        conn.setRequestProperty("User-Agent", "aop-sdk-java");
        conn.setRequestProperty("Accept", "application/json");
        conn.setRequestProperty("Content-Type", ctype);
        return conn;
    }

    private static URL buildGetUrl(String strUrl, String query) throws IOException {
        URL url = new URL(strUrl);
        if (StringUtils.isEmpty(query)) {
            return url;
        }
        strUrl = StringUtils.isEmpty(url.getQuery()) ? (strUrl.endsWith("?") ? strUrl + query : strUrl + "?" + query) : (strUrl.endsWith("&") ? strUrl + query : strUrl + "&" + query);
        return new URL(strUrl);
    }

    public static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String value;
            String name = entry.getKey();
            if (!StringUtils.areNotEmpty(name, value = entry.getValue())) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = FopWebUtils.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return FopWebUtils.getStreamAsString(conn.getInputStream(), charset);
        }
        String msg = FopWebUtils.getStreamAsString(es, charset);
        if (StringUtils.isEmpty(msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            int count;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
            StringWriter writer = new StringWriter();
            char[] chars = new char[256];
            while ((count = reader.read(chars)) > 0) {
                writer.write(chars, 0, count);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (!StringUtils.isEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtils.isEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    public static String decode(String value) {
        return FopWebUtils.decode(value, DEFAULT_CHARSET);
    }

    public static String decode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty(value)) {
            try {
                result = URLDecoder.decode(value, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private static Map<String, String> getParamsFromUrl(String url) {
        Map<Object, Object> map = null;
        if (url != null && url.indexOf(63) != -1) {
            map = FopWebUtils.splitUrlQuery(url.substring(url.indexOf(63) + 1));
        }
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    public static Map<String, String> splitUrlQuery(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] pairs = query.split("&");
        if (pairs != null && pairs.length > 0) {
            for (String pair : pairs) {
                String[] param = pair.split("=", 2);
                if (param == null || param.length != 2) continue;
                result.put(param[0], param[1]);
            }
        }
        return result;
    }

    public String buildForm(String baseUrl, RequestParametersHolder requestHolder) {
        return null;
    }

    public static String buildForm(String baseUrl, Map<String, String> parameters) {
        StringBuffer sb = new StringBuffer();
        sb.append("<form name=\"punchout_form\" method=\"post\" action=\"");
        sb.append(baseUrl);
        sb.append("\">\n");
        sb.append(FopWebUtils.buildHiddenFields(parameters));
        sb.append("<input type=\"submit\" value=\"\u7acb\u5373\u652f\u4ed8\" style=\"display:none\" >\n");
        sb.append("</form>\n");
        sb.append("<script>document.forms[0].submit();</script>");
        String form = sb.toString();
        return form;
    }

    private static String buildHiddenFields(Map<String, String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Set<String> keys = parameters.keySet();
        for (String key : keys) {
            String value = parameters.get(key);
            if (key == null || value == null) continue;
            sb.append(FopWebUtils.buildHiddenField(key, value));
        }
        String result = sb.toString();
        return result;
    }

    private static String buildHiddenField(String key, String value) {
        StringBuffer sb = new StringBuffer();
        sb.append("<input type=\"hidden\" name=\"");
        sb.append(key);
        sb.append("\" value=\"");
        String a = value.replace("\"", "&quot;");
        sb.append(a).append("\">\n");
        return sb.toString();
    }

    static {
        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            ctx.getClientSessionContext().setSessionTimeout(15);
            ctx.getClientSessionContext().setSessionCacheSize(1000);
            socketFactory = ctx.getSocketFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        verifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return false;
            }
        };
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            X509Certificate[] array = new X509Certificate[]{};
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

