/*
 * Decompiled with CFR 0.152.
 */
package com.uop.sdk.internal.util;

import com.uop.sdk.FopObject;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;

public class MapToBeanUtils<T> {
    public static <T> T convertMap2Bean(Map<String, Object> map, Class<T> T) throws Exception {
        if (map == null || map.size() == 0) {
            return T.newInstance();
        }
        Object mvalue = null;
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        Iterator<Map.Entry<String, Object>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            String key = it.next().getKey();
            mvalue = map.get(key);
            if (key.indexOf("_") != -1) {
                key = key.replaceAll("_", "");
            }
            newMap.put(key.toUpperCase(Locale.US), mvalue);
        }
        BeanInfo beanInfo = Introspector.getBeanInfo(T);
        T bean = T.newInstance();
        for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
            String propertyName = descriptor.getName();
            String upperPropertyName = propertyName.toUpperCase();
            if (!newMap.keySet().contains(upperPropertyName)) continue;
            Object value = newMap.get(upperPropertyName);
            if (descriptor.getPropertyType() instanceof Class && value instanceof Map) {
                PropertyDescriptor[] innerPropertyDescriptors;
                FopObject innerClass = (FopObject)Class.forName(descriptor.getPropertyType().getName()).newInstance();
                BeanInfo innerBeanInfo = Introspector.getBeanInfo(innerClass.getClass());
                for (PropertyDescriptor innerDescriptor : innerPropertyDescriptors = innerBeanInfo.getPropertyDescriptors()) {
                    String innerPropertyName = innerDescriptor.getName();
                    if ("class".equals(innerPropertyName)) continue;
                    BeanUtils.copyProperty((Object)innerClass, (String)innerPropertyName, ((Map)value).get(innerPropertyName));
                }
                BeanUtils.copyProperty(bean, (String)propertyName, (Object)innerClass);
                continue;
            }
            BeanUtils.copyProperty(bean, (String)propertyName, value);
        }
        return bean;
    }

    public static Map<String, Object> convertBean2Map(Object bean) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        Class<?> type = bean.getClass();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        BeanInfo beanInfo = Introspector.getBeanInfo(type);
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor descriptor = propertyDescriptors[i];
            String propertyName = descriptor.getName();
            if ("class".equals(propertyName)) continue;
            Method readMethod = descriptor.getReadMethod();
            Object result = readMethod.invoke(bean, new Object[0]);
            if (result != null) {
                returnMap.put(propertyName, result);
                continue;
            }
            returnMap.put(propertyName, null);
        }
        return returnMap;
    }

    public static <T> List<T> convertListMap2ListBean(List<Map<String, Object>> listMap, Class<T> T) throws Exception {
        ArrayList<T> beanList = new ArrayList<T>();
        if (listMap != null && !listMap.isEmpty()) {
            int n = listMap.size();
            for (int i = 0; i < n; ++i) {
                Map<String, Object> map = listMap.get(i);
                T bean = MapToBeanUtils.convertMap2Bean(map, T);
                beanList.add(bean);
            }
            return beanList;
        }
        return beanList;
    }

    public static <T> List<Map<String, Object>> convertListBean2ListMap(List<T> beanList, Class<T> T) throws Exception {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        int n = beanList.size();
        for (int i = 0; i < n; ++i) {
            T bean = beanList.get(i);
            Map<String, Object> map = MapToBeanUtils.convertBean2Map(bean);
            mapList.add(map);
        }
        return mapList;
    }
}

