/*
 * Decompiled with CFR 0.152.
 */
package com.uop.sdk.internal.util;

import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

public class SM2Util {
    private static final String SM2_ALG = "EC";
    private static final String SM2_STD = "sm2p256v1";

    public static void main(String[] args) throws InterruptedException {
    }

    public static String sign(String content, String privateKey) {
        return SM2Util.sign(content, SM2Util.generatePrivateKey(privateKey));
    }

    public static String sign(String content, PrivateKey privateKey) {
        String signContent = null;
        try {
            Signature signature = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), (Provider)new BouncyCastleProvider());
            signature.initSign(privateKey);
            byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
            signature.update(contentBytes);
            byte[] signBytes = signature.sign();
            signContent = Hex.toHexString((byte[])signBytes);
        }
        catch (InvalidKeyException e) {
        }
        catch (SignatureException e) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return signContent;
    }

    public static boolean check(String content, String sign, String publicKey) {
        return SM2Util.check(content, sign, SM2Util.generatePublicKey(publicKey));
    }

    public static boolean check(String content, String sign, PublicKey publicKey) {
        boolean verifyFlag = false;
        try {
            Signature signature = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), (Provider)new BouncyCastleProvider());
            signature.initVerify(publicKey);
            byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
            signature.update(contentBytes);
            byte[] signBytes = Hex.decode((String)sign);
            verifyFlag = signature.verify(signBytes);
        }
        catch (InvalidKeyException e) {
        }
        catch (SignatureException e) {
        }
        catch (NoSuchAlgorithmException e) {
            // empty catch block
        }
        return verifyFlag;
    }

    public static PublicKey generatePublicKey(String publicKeyStr) {
        PublicKey publicKey = null;
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(Base64.decode((String)publicKeyStr));
            KeyFactory publickeyFactory = KeyFactory.getInstance(SM2_ALG, (Provider)new BouncyCastleProvider());
            publicKey = publickeyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            // empty catch block
        }
        return publicKey;
    }

    public static PrivateKey generatePrivateKey(String privateKeyStr) {
        PrivateKey privateKey = null;
        try {
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(Base64.decode((String)privateKeyStr));
            KeyFactory privatekeyFactory = KeyFactory.getInstance(SM2_ALG, (Provider)new BouncyCastleProvider());
            privateKey = privatekeyFactory.generatePrivate(pkcs8EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            // empty catch block
        }
        return privateKey;
    }

    public static KeyPair generateKeyPair() {
        KeyPair keyPair = null;
        try {
            ECGenParameterSpec sm2Spec = new ECGenParameterSpec(SM2_STD);
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(SM2_ALG, (Provider)new BouncyCastleProvider());
            kpg.initialize(sm2Spec);
            kpg.initialize(sm2Spec, new SecureRandom());
            keyPair = kpg.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
        return keyPair;
    }
}

