/*
 * Decompiled with CFR 0.152.
 */
package com.uop.sdk.internal.util.json;

import com.uop.sdk.internal.mapping.ApiField;
import com.uop.sdk.internal.mapping.ApiListField;
import com.uop.sdk.internal.util.FopLogger;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.TimeZone;

public class JSONWriter {
    private StringBuffer buf = new StringBuffer();
    private Stack<Object> calls = new Stack();
    private boolean emitClassName = true;
    private DateFormat format;
    static char[] hex = "0123456789ABCDEF".toCharArray();

    public JSONWriter(boolean emitClassName) {
        this.emitClassName = emitClassName;
    }

    public JSONWriter() {
        this(false);
    }

    public JSONWriter(DateFormat format) {
        this(false);
        this.format = format;
    }

    public String write(Object object) {
        return this.write(object, false);
    }

    public String write(Object object, boolean isApiModel) {
        this.buf.setLength(0);
        this.value(object, isApiModel);
        return this.buf.toString();
    }

    public String write(long n) {
        return String.valueOf(n);
    }

    public String write(double d) {
        return String.valueOf(d);
    }

    public String write(char c) {
        return "\"" + c + "\"";
    }

    public String write(boolean b) {
        return String.valueOf(b);
    }

    private void value(Object object) {
        this.value(object, false);
    }

    private void value(Object object, boolean isApiModel) {
        if (object == null || this.cyclic(object)) {
            this.add(null);
        } else {
            this.calls.push(object);
            if (object instanceof Class) {
                this.string(object);
            } else if (object instanceof Boolean) {
                this.bool((Boolean)object);
            } else if (object instanceof Number) {
                this.add(object);
            } else if (object instanceof String) {
                this.string(object);
            } else if (object instanceof Character) {
                this.string(object);
            } else if (object instanceof Map) {
                this.map((Map)object);
            } else if (object.getClass().isArray()) {
                this.array(object, isApiModel);
            } else if (object instanceof Iterator) {
                this.array((Iterator)object, isApiModel);
            } else if (object instanceof Collection) {
                this.array(((Collection)object).iterator(), isApiModel);
            } else if (object instanceof Date) {
                this.date((Date)object);
            } else if (isApiModel) {
                this.model(object);
            } else {
                this.bean(object);
            }
            this.calls.pop();
        }
    }

    private boolean cyclic(Object object) {
        for (Object e : this.calls) {
            if (object != e) continue;
            return true;
        }
        return false;
    }

    private void bean(Object object) {
        this.add("{");
        boolean addedSomething = false;
        try {
            BeanInfo info = Introspector.getBeanInfo(object.getClass());
            PropertyDescriptor[] props = info.getPropertyDescriptors();
            for (int i = 0; i < props.length; ++i) {
                Object value;
                PropertyDescriptor prop = props[i];
                String name = prop.getName();
                Method accessor = prop.getReadMethod();
                if (!this.emitClassName && "class".equals(name) || accessor == null) continue;
                if (!accessor.isAccessible()) {
                    accessor.setAccessible(true);
                }
                if ((value = accessor.invoke(object, (Object[])null)) == null) continue;
                if (addedSomething) {
                    this.add(',');
                }
                this.add(name, value);
                addedSomething = true;
            }
            Field[] ff = object.getClass().getFields();
            for (int i = 0; i < ff.length; ++i) {
                Field field = ff[i];
                Object value = field.get(object);
                if (value == null) continue;
                if (addedSomething) {
                    this.add(',');
                }
                this.add(field.getName(), value);
                addedSomething = true;
            }
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException ite) {
        }
        catch (IntrospectionException ie) {
            // empty catch block
        }
        this.add("}");
    }

    private void model(Object object) {
        this.add("{");
        boolean addedSomething = false;
        Field[] ff = object.getClass().getDeclaredFields();
        try {
            for (int i = 0; i < ff.length; ++i) {
                Object value;
                Method accessor;
                PropertyDescriptor pd;
                Field field = ff[i];
                ApiField jsonField = field.getAnnotation(ApiField.class);
                ApiListField listField = field.getAnnotation(ApiListField.class);
                if (listField != null) {
                    pd = new PropertyDescriptor(field.getName(), object.getClass());
                    accessor = pd.getReadMethod();
                    if (!accessor.isAccessible()) {
                        accessor.setAccessible(true);
                    }
                    if ((value = accessor.invoke(object, (Object[])null)) == null) continue;
                    if (addedSomething) {
                        this.add(',');
                    }
                    this.add(listField.value(), value, true);
                    addedSomething = true;
                    continue;
                }
                if (jsonField == null) continue;
                pd = new PropertyDescriptor(field.getName(), object.getClass());
                accessor = pd.getReadMethod();
                if (!accessor.isAccessible()) {
                    accessor.setAccessible(true);
                }
                if ((value = accessor.invoke(object, (Object[])null)) == null) continue;
                if (addedSomething) {
                    this.add(',');
                }
                this.add(jsonField.value(), value, true);
                addedSomething = true;
            }
        }
        catch (IntrospectionException e1) {
            FopLogger.logBizError(e1);
        }
        catch (IllegalAccessException e2) {
            FopLogger.logBizError(e2);
        }
        catch (IllegalArgumentException e3) {
            FopLogger.logBizError(e3);
        }
        catch (InvocationTargetException e4) {
            FopLogger.logBizError(e4);
        }
        this.add("}");
    }

    private void add(String name, Object value) {
        this.add(name, value, false);
    }

    private void add(String name, Object value, boolean isApiModel) {
        this.add('\"');
        this.add(name);
        this.add("\":");
        this.value(value, isApiModel);
    }

    private void map(Map<?, ?> map) {
        this.add("{");
        Iterator<Map.Entry<?, ?>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<?, ?> e = it.next();
            this.value(e.getKey());
            this.add(":");
            this.value(e.getValue());
            if (!it.hasNext()) continue;
            this.add(',');
        }
        this.add("}");
    }

    private void array(Iterator<?> it) {
        this.array(it, false);
    }

    private void array(Iterator<?> it, boolean isApiModel) {
        this.add("[");
        while (it.hasNext()) {
            this.value(it.next(), isApiModel);
            if (!it.hasNext()) continue;
            this.add(",");
        }
        this.add("]");
    }

    private void array(Object object) {
        this.array(object, false);
    }

    private void array(Object object, boolean isApiModel) {
        this.add("[");
        int length = Array.getLength(object);
        for (int i = 0; i < length; ++i) {
            this.value(Array.get(object, i), isApiModel);
            if (i >= length - 1) continue;
            this.add(',');
        }
        this.add("]");
    }

    private void bool(boolean b) {
        this.add(b ? "true" : "false");
    }

    private void date(Date date) {
        if (this.format == null) {
            this.format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.format.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        }
        this.add("\"");
        this.add(this.format.format(date));
        this.add("\"");
    }

    private void string(Object obj) {
        this.add('\"');
        StringCharacterIterator it = new StringCharacterIterator(obj.toString());
        char c = it.first();
        while (c != '\uffff') {
            if (c == '\"') {
                this.add("\\\"");
            } else if (c == '\\') {
                this.add("\\\\");
            } else if (c == '/') {
                this.add("\\/");
            } else if (c == '\b') {
                this.add("\\b");
            } else if (c == '\f') {
                this.add("\\f");
            } else if (c == '\n') {
                this.add("\\n");
            } else if (c == '\r') {
                this.add("\\r");
            } else if (c == '\t') {
                this.add("\\t");
            } else if (Character.isISOControl(c)) {
                this.unicode(c);
            } else {
                this.add(c);
            }
            c = it.next();
        }
        this.add('\"');
    }

    private void add(Object obj) {
        this.buf.append(obj);
    }

    private void add(char c) {
        this.buf.append(c);
    }

    private void unicode(char c) {
        this.add("\\u");
        int n = c;
        for (int i = 0; i < 4; ++i) {
            int digit = (n & 0xF000) >> 12;
            this.add(hex[digit]);
            n <<= 4;
        }
    }
}

