/*
 * Decompiled with CFR 0.152.
 */
package com.sccba.open.api;

import com.sccba.open.api.ICache;
import com.sccba.open.api.OpenAPI;
import com.sccba.open.oauth2.AccessTokenResponse;
import com.sccba.open.util.ConfigUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class TokenMaintenance {
    public static final String CONFIG = "sccba_open_api";
    public static final String APPID = "appId";
    public static final String SECRET = "secret";
    public static final String BANKID = "bankId";
    public static final Map<String, Object> cacheMap = new HashMap<String, Object>();
    static final String expiresDateKey = "expiresDateKey";
    static final String accessTokenKey = "accessTokenKey";
    public static String accessToken = "";
    static String expiresDate = "";
    public static ICache cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static String getAccessToken(String bankId, String configpath) throws Exception {
        OpenAPI openAPI = new OpenAPI();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String currentDate = sdf.format(new Date());
        long from = 0L;
        try {
            from = sdf.parse(currentDate).getTime();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        String token2 = "";
        String expires = "";
        if (bankId != cacheMap.get(BANKID)) {
            cacheMap.put(BANKID, bankId);
            AccessTokenResponse accessTokenResponse = openAPI.accessToken(bankId, ConfigUtil.getAppId("", bankId), ConfigUtil.getAppSecret("", bankId));
            accessToken = token2 = accessTokenResponse.getAccessToken();
            expiresDate = expires = accessTokenResponse.getTokenExpiresDate();
        } else if (TokenMaintenance.compareTokenXepiresDate(from, sdf)) {
            Class<TokenMaintenance> clazz = TokenMaintenance.class;
            // MONITORENTER : com.sccba.open.api.TokenMaintenance.class
            if (TokenMaintenance.compareTokenXepiresDate(from, sdf)) {
                AccessTokenResponse accessTokenResponse = openAPI.accessToken(bankId, ConfigUtil.getAppId("", bankId), ConfigUtil.getAppSecret("", bankId));
                token2 = accessTokenResponse.getAccessToken();
                expires = accessTokenResponse.getTokenExpiresDate();
                if (cache != null) {
                    cache.set(accessTokenKey, token2);
                    cache.set(expiresDateKey, expires);
                } else {
                    accessToken = token2;
                    expiresDate = expires;
                }
            }
            // MONITOREXIT : clazz
        }
        if (token2 != null) {
            if (!"".equals(token2)) return token2;
        }
        if (cache == null) return accessToken;
        return (String)cache.get(accessTokenKey);
    }

    private static boolean compareTokenXepiresDate(long from, SimpleDateFormat sdf) {
        long to;
        try {
            String expires = expiresDate;
            if (cache != null) {
                expires = (String)cache.get(expiresDateKey);
            }
            if (expires == null) {
                expires = expiresDate;
            }
            to = sdf.parse(expires).getTime();
        }
        catch (ParseException e) {
            to = from;
        }
        String aheadOfTime = ConfigUtil.getAheadOfTime();
        if (aheadOfTime == null || "".equals(aheadOfTime)) {
            aheadOfTime = "3";
        }
        return from + (long)(Integer.parseInt(aheadOfTime) * 1000 * 60) >= to;
    }
}

