/*
 * Decompiled with CFR 0.152.
 */
package com.sccba.open.http;

public class Base64 {
    private static byte[] base64Alphabet = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 60, 47};
    private static byte pad = (byte)61;

    public static byte[] decode(byte[] src) {
        int k = 0;
        int n = 0;
        byte[] dst = new byte[src.length];
        int i = 0;
        while (i < src.length) {
            n = 0;
            byte l = 0;
            int j = 0;
            while (j < 4) {
                l = Base64.getReverseMapping(src[i + j]);
                if (l == -1) break;
                n = (n << 6) + l;
                ++j;
            }
            if (j == 4) {
                dst[k++] = (byte)(n >> 16 & 0xFF);
                dst[k++] = (byte)(n >> 8 & 0xFF);
                dst[k++] = (byte)(n & 0xFF);
            } else {
                if (j == 3) {
                    dst[k++] = (byte)((n <<= 6) >> 16 & 0xFF);
                    dst[k++] = (byte)(n >> 8 & 0xFF);
                    break;
                }
                if (j == 2) {
                    dst[k++] = (byte)((n <<= 12) >> 16 & 0xFF);
                    break;
                }
            }
            i += 4;
        }
        byte[] tmp = new byte[k];
        System.arraycopy(dst, 0, tmp, 0, k);
        return tmp;
    }

    public static byte[] encode(byte[] src) {
        int k = 0;
        int n = 0;
        int len = src.length;
        byte[] dst = new byte[len * 2];
        int i = 0;
        while (i + 2 < len) {
            n = (src[i] & 0xFF) << 16;
            n += (src[i + 1] & 0xFF) << 8;
            dst[k++] = base64Alphabet[(n += src[i + 2] & 0xFF) >> 18 & 0x3F];
            dst[k++] = base64Alphabet[n >> 12 & 0x3F];
            dst[k++] = base64Alphabet[n >> 6 & 0x3F];
            dst[k++] = base64Alphabet[n & 0x3F];
            i += 3;
        }
        if (len % 3 == 2) {
            n = (src[i] & 0xFF) << 16;
            dst[k++] = base64Alphabet[(n += (src[i + 1] & 0xFF) << 8) >> 18 & 0x3F];
            dst[k++] = base64Alphabet[n >> 12 & 0x3F];
            dst[k++] = base64Alphabet[n >> 6 & 0x3F];
            dst[k++] = pad;
        } else if (len % 3 == 1) {
            n = (src[i] & 0xFF) << 16;
            dst[k++] = base64Alphabet[n >> 18 & 0x3F];
            dst[k++] = base64Alphabet[n >> 12 & 0x3F];
            dst[k++] = pad;
            dst[k++] = pad;
        }
        byte[] retBuf = new byte[k];
        System.arraycopy(dst, 0, retBuf, 0, k);
        return retBuf;
    }

    private static byte getReverseMapping(byte chr) {
        int i = 0;
        while (i < 64) {
            if (base64Alphabet[i] == chr) {
                return (byte)i;
            }
            ++i;
        }
        return -1;
    }
}

