/*
 * Decompiled with CFR 0.152.
 */
package com.sccba.open.http;

import com.sccba.open.util.ConfigUtil;
import com.sccba.open.util.LoggerUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class HttpClientHelper {
    private PoolingHttpClientConnectionManager poolConnManager = null;
    private Map<String, SSLContext> sslContextMap = new HashMap<String, SSLContext>();
    private String configFilePath = null;
    private String bankId = "";
    private String channel = "";
    private int maxTotalPool;
    private int maxConPerRoute;
    private int connectionRequestTimeout;
    private int connectTimeout;
    private int socketTimeout;
    private String proxyIp;
    private int proxyPort;
    private String httpsFlag;

    public HttpClientHelper(String bankId, String channel, String configFilePath) throws Exception {
        this.init(bankId, channel, configFilePath);
    }

    public void init(String bankId, String channel, String configFilePath) throws Exception {
        LoggerUtil.log(LoggerUtil.DEBUG, "==init bankId==" + bankId + "==channel==" + channel + "==configFilePath==" + configFilePath);
        if (!ConfigUtil.isResourceMode()) {
            ConfigUtil.initProperties(configFilePath);
        }
        this.bankId = bankId;
        this.channel = channel;
        this.configFilePath = configFilePath;
        this.maxTotalPool = ConfigUtil.getMaxTotalPool(channel, bankId);
        this.maxConPerRoute = ConfigUtil.getMaxConPerRoute(channel, bankId);
        this.connectionRequestTimeout = ConfigUtil.getConnectionRequestTimeout(channel, bankId);
        this.connectTimeout = ConfigUtil.getConnectTimeout(channel, bankId);
        this.socketTimeout = ConfigUtil.getSocketTimeout(channel, bankId);
        this.proxyIp = ConfigUtil.getProxyIp(channel, bankId);
        this.proxyPort = ConfigUtil.getProxyPort(channel, bankId);
        this.httpsFlag = ConfigUtil.getHttpsFlag(channel, bankId);
        PoolingHttpClientConnectionManager connManager = null;
        String baseUrl = ConfigUtil.getBaseUrl(channel, bankId);
        LoggerUtil.log(LoggerUtil.DEBUG, "==init baseUrl==" + baseUrl);
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        registryBuilder.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        if (("".equals(this.httpsFlag) || this.httpsFlag == null) && "https".equalsIgnoreCase(new URL(baseUrl).getProtocol())) {
            SSLContext sslContext = this.getSSLContext(this.channel, this.bankId);
            HostnameVerifier hostnameVerifier = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, hostnameVerifier);
            registryBuilder.register("https", (Object)sslsf);
        }
        Registry socketFactoryRegistry = registryBuilder.build();
        connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connManager.setMaxTotal(this.maxTotalPool);
        connManager.setDefaultMaxPerRoute(this.maxConPerRoute);
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(this.socketTimeout).build();
        connManager.setDefaultSocketConfig(socketConfig);
        this.poolConnManager = connManager;
    }

    public String doGet(String url) throws Exception {
        return this.doGet(url, new HashMap<String, Object>());
    }

    public String doGet(String url, Map<String, Object> params) throws Exception {
        String apiUrl = url;
        StringBuffer param = new StringBuffer();
        int i = 0;
        for (String key : params.keySet()) {
            if (i == 0) {
                param.append("?");
            } else {
                param.append("&");
            }
            param.append(key).append("=").append(params.get(key));
            ++i;
        }
        apiUrl = String.valueOf(apiUrl) + param;
        System.out.println("==doGet apiUrl==" + apiUrl);
        LoggerUtil.log(LoggerUtil.DEBUG, "==doGet apiUrl==" + apiUrl);
        String result = null;
        CloseableHttpClient httpClient = this.getConnection();
        CloseableHttpResponse response = null;
        HttpGet httpGet = null;
        try {
            httpGet = new HttpGet(apiUrl);
            response = httpClient.execute((HttpUriRequest)httpGet);
            if (response != null) {
                int status = response.getStatusLine().getStatusCode();
                System.out.println("==http doGet request url==" + url + "==status==" + status);
                LoggerUtil.log(LoggerUtil.DEBUG, "==http doGet request url==" + url + "==status==" + status);
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    System.out.println("==http doGet Request result :" + result);
                    LoggerUtil.log(LoggerUtil.DEBUG, "==http doGet Request result :" + result);
                }
            }
            String string = result;
            return string;
        }
        catch (Exception e) {
            LoggerUtil.log(LoggerUtil.ERROR, "==doGet error==" + e.getMessage(), e);
            throw e;
        }
        finally {
            httpGet.releaseConnection();
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    response.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String doPost(String url) throws Exception {
        return this.doPost(url, new HashMap<String, Object>());
    }

    public String doPost(String url, Map<String, Object> params) throws Exception {
        String result = null;
        HttpPost httpPost = new HttpPost(url);
        CloseableHttpClient httpClient = this.getConnection();
        CloseableHttpResponse response = null;
        System.out.println("==http doPost params url==" + url + "==params==" + params);
        LoggerUtil.log(LoggerUtil.DEBUG, "==http doPost params url==" + url + "==params==" + params);
        try {
            ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                pairList.add(pair);
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
            response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null) {
                int status = response.getStatusLine().getStatusCode();
                System.out.println("==http doPost  http request url :" + url + " status :" + status);
                LoggerUtil.log(LoggerUtil.DEBUG, "==http doPost  http request url :" + url + " status :" + status);
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    result = EntityUtils.toString((HttpEntity)entity, (String)"GBK");
                    System.out.println("==http doPost Request result :" + result);
                    LoggerUtil.log(LoggerUtil.DEBUG, "==http doPost Request result :" + result);
                }
            }
            String string = result;
            return string;
        }
        catch (Exception e) {
            System.out.println("==doGet error==" + e.getMessage());
            LoggerUtil.log(LoggerUtil.ERROR, "==doGet error==" + e.getMessage(), e);
            throw e;
        }
        finally {
            httpPost.releaseConnection();
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    response.close();
                }
                catch (IOException e) {
                    System.out.println("==doGet error==" + e.getMessage());
                    LoggerUtil.log(LoggerUtil.ERROR, "==doGet error==" + e.getMessage(), e);
                }
            }
        }
    }

    public CloseableHttpClient getConnection() throws Exception {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.connectionRequestTimeout).setConnectTimeout(this.connectTimeout).setSocketTimeout(this.socketTimeout).build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)this.poolConnManager).setDefaultRequestConfig(requestConfig);
        if (this.proxyIp != null && !this.proxyIp.isEmpty()) {
            HttpHost proxy = new HttpHost(this.proxyIp, Integer.valueOf(this.proxyPort).intValue());
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        }
        CloseableHttpClient httpClient = httpClientBuilder.build();
        if (this.poolConnManager != null && this.poolConnManager.getTotalStats() != null) {
            LoggerUtil.log(LoggerUtil.DEBUG, "==now client pool==" + this.poolConnManager.getTotalStats().toString());
        }
        return httpClient;
    }

    private SSLContext getSSLContext(String channel, String bankId) throws Exception {
        String configKey = ConfigUtil.isNotEmpty(ConfigUtil.getKey(channel, bankId)) ? ConfigUtil.getKey(channel, bankId) : "800";
        SSLContext context = null;
        if (this.sslContextMap != null && this.sslContextMap.get(configKey) != null) {
            context = this.sslContextMap.get(configKey);
        } else {
            context = SSLContext.getInstance("TLS");
            String instance = ConfigUtil.iProviderType == 1 ? "ibmX509" : "SunX509";
            Security.addProvider((Provider)new BouncyCastleProvider());
            String mTrustStoreBase = ConfigUtil.getTrustStoreBase(channel, bankId);
            String mTrustStore = ConfigUtil.getTrustStore(channel, bankId);
            String mTrustStore1 = ConfigUtil.getTrustStore1(channel, bankId);
            String mTrustStore2 = ConfigUtil.getTrustStore2(channel, bankId);
            String mClientKeyStore = ConfigUtil.getClientStore(channel, bankId);
            String mClientKeyStorePwd = ConfigUtil.getClientStorePwd(channel, bankId);
            String mTrustKeyStorePwd = ConfigUtil.getMTrustKeyStorePwd(channel, bankId);
            InputStream mClientKeyStoreFile = null;
            InputStream mTrustStoreFile = null;
            InputStream mTrustStore1File = null;
            InputStream mTrustStore2File = null;
            InputStream KeyStoreInuptStream = null;
            KeyStore ks = null;
            ks = mClientKeyStore != null && mClientKeyStore.endsWith(".jks") ? KeyStore.getInstance("JKS") : KeyStore.getInstance("PKCS12", "BC");
            KeyManagerFactory kf = KeyManagerFactory.getInstance(instance);
            try {
                try {
                    mClientKeyStoreFile = this.getFileInputStream(mClientKeyStore);
                    ks.load(mClientKeyStoreFile, mClientKeyStorePwd.toCharArray());
                    kf.init(ks, mClientKeyStorePwd.toCharArray());
                    KeyStore trustStore = KeyStore.getInstance("JKS");
                    TrustManagerFactory trustFact = TrustManagerFactory.getInstance(instance);
                    if (mTrustStoreBase == null || mTrustStoreBase.isEmpty()) {
                        trustStore.load(null, null);
                        CertificateFactory fact = CertificateFactory.getInstance("X.509");
                        mTrustStoreFile = this.getFileInputStream(mTrustStore);
                        trustStore.setEntry("root", new KeyStore.TrustedCertificateEntry(fact.generateCertificate(mTrustStoreFile)), null);
                        mTrustStore1File = this.getFileInputStream(mTrustStore1);
                        trustStore.setEntry("cross", new KeyStore.TrustedCertificateEntry(fact.generateCertificate(mTrustStore1File)), null);
                        if (mTrustStore2 != null && !mTrustStore2.isEmpty()) {
                            mTrustStore2File = this.getFileInputStream(mTrustStore2);
                            trustStore.setEntry("issuer", new KeyStore.TrustedCertificateEntry(fact.generateCertificate(mTrustStore2File)), null);
                        }
                    }
                    trustFact.init(trustStore);
                    context.init(kf.getKeyManagers(), trustFact.getTrustManagers(), null);
                    this.sslContextMap.put(configKey, context);
                }
                catch (Exception e) {
                    LoggerUtil.log(LoggerUtil.ERROR, "==getSSLContext error==" + e.getMessage(), e);
                    if (mTrustStore2File != null) {
                        mTrustStore2File.close();
                    }
                    if (mTrustStore1File != null) {
                        mTrustStore1File.close();
                    }
                    if (mTrustStoreFile != null) {
                        mTrustStoreFile.close();
                    }
                    if (mClientKeyStoreFile != null) {
                        mClientKeyStoreFile.close();
                    }
                    if (KeyStoreInuptStream != null) {
                        KeyStoreInuptStream.close();
                    }
                }
            }
            finally {
                if (mTrustStore2File != null) {
                    mTrustStore2File.close();
                }
                if (mTrustStore1File != null) {
                    mTrustStore1File.close();
                }
                if (mTrustStoreFile != null) {
                    mTrustStoreFile.close();
                }
                if (mClientKeyStoreFile != null) {
                    mClientKeyStoreFile.close();
                }
                if (KeyStoreInuptStream != null) {
                    KeyStoreInuptStream.close();
                }
            }
        }
        return context;
    }

    private InputStream getFileInputStream(String path) throws FileNotFoundException {
        InputStream ins = this.getClass().getResourceAsStream("/com/sccba/open/resource/cert/" + path);
        if (ins == null) {
            ins = new FileInputStream(path);
        }
        return ins;
    }

    public String getBankId() {
        return this.bankId;
    }

    public void setBankId(String bankId) {
        this.bankId = bankId;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getConfigFilePath() {
        return this.configFilePath;
    }

    public void setConfigFilePath(String configFilePath) {
        this.configFilePath = configFilePath;
    }
}

