/*
 * Decompiled with CFR 0.152.
 */
package com.sccba.open.oauth2;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sccba.open.http.HttpClientHelper;
import com.sccba.open.http.HttpClientHelperContainer;
import com.sccba.open.oauth2.APIRequest;
import com.sccba.open.oauth2.APIResponse;
import com.sccba.open.oauth2.AccessTokenRequest;
import com.sccba.open.oauth2.AccessTokenResponse;
import com.sccba.open.oauth2.Oauth2;
import com.sccba.open.oauth2.RefreshTokenRequest;
import com.sccba.open.oauth2.RefreshTokenResponse;
import com.sccba.open.oauth2.TicketRequest;
import com.sccba.open.oauth2.TicketResponse;
import com.sccba.open.util.BeanUtils;
import com.sccba.open.util.ConfigUtil;
import com.sccba.open.util.JsonDataUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class Oauth2API
implements Oauth2 {
    private String configFilePath = "";
    private static final String VERSION = "1.0.0.0";

    public Oauth2API() {
    }

    public Oauth2API(String configFilePath) {
        this.configFilePath = configFilePath;
    }

    @Override
    public AccessTokenResponse accessToken(String appId, String secret) throws Exception {
        return this.accessToken("", "", appId, secret);
    }

    @Override
    public AccessTokenResponse accessToken(String bankId, String appId, String secret) throws Exception {
        return this.accessToken(bankId, "", appId, secret);
    }

    @Override
    public AccessTokenResponse accessToken(String bankId, String channel, String appId, String secret) throws Exception {
        HttpClientHelperContainer container = HttpClientHelperContainer.getInstance(bankId, channel, this.configFilePath);
        HttpClientHelper httpClient = container.getHttpClientHelper(bankId, channel, this.configFilePath);
        HashMap<String, Object> params = new HashMap();
        AccessTokenRequest acr = new AccessTokenRequest();
        acr.setClientId(appId);
        acr.setClientSecret(secret);
        acr.setGrantType("client_credentials");
        params = BeanUtils.convertBeanToMap(acr);
        String response = httpClient.doPost(String.valueOf(ConfigUtil.getBaseUrl(channel, bankId)) + "/oauth/token", params);
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        return (AccessTokenResponse)gson.fromJson(response, AccessTokenResponse.class);
    }

    @Override
    public RefreshTokenResponse refreshToken(String refreshToken) throws Exception {
        return this.refreshToken("", "", refreshToken);
    }

    @Override
    public RefreshTokenResponse refreshToken(String bankId, String refreshToken) throws Exception {
        return this.refreshToken(bankId, "", refreshToken);
    }

    @Override
    public RefreshTokenResponse refreshToken(String bankId, String channel, String refreshToken) throws Exception {
        HttpClientHelperContainer container = HttpClientHelperContainer.getInstance(bankId, channel, this.configFilePath);
        HttpClientHelper httpClient = container.getHttpClientHelper(bankId, channel, this.configFilePath);
        HashMap<String, Object> params = new HashMap();
        RefreshTokenRequest retr = new RefreshTokenRequest();
        retr.setRefreshToken(refreshToken);
        retr.setGrantType("refresh_token");
        params = BeanUtils.convertBeanToMap(retr);
        String response = httpClient.doGet(String.valueOf(ConfigUtil.getBaseUrl(channel, bankId)) + "/oauth/token", params);
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        return (RefreshTokenResponse)gson.fromJson(response, RefreshTokenResponse.class);
    }

    @Override
    public TicketResponse apiTicket(String appId, String accessToken, String userId) throws Exception {
        return this.apiTicket("", "", appId, accessToken, userId);
    }

    @Override
    public TicketResponse apiTicket(String bankId, String appId, String accessToken, String userId) throws Exception {
        return this.apiTicket(bankId, "", appId, accessToken, userId);
    }

    @Override
    public TicketResponse apiTicket(String bankId, String channel, String appId, String accessToken, String userId) throws Exception {
        HttpClientHelperContainer container = HttpClientHelperContainer.getInstance(bankId, channel, this.configFilePath);
        HttpClientHelper httpClient = container.getHttpClientHelper(bankId, channel, this.configFilePath);
        HashMap<String, Object> params = new HashMap();
        TicketRequest tr = new TicketRequest();
        tr.setAccessToken(accessToken);
        tr.setAppId(appId);
        tr.setUserId(userId);
        tr.setVersion(VERSION);
        params = BeanUtils.convertBeanToMap(tr);
        String response = httpClient.doGet(String.valueOf(ConfigUtil.getBaseUrl(channel, bankId)) + "/ticket", params);
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        return (TicketResponse)gson.fromJson(response, TicketResponse.class);
    }

    @Override
    public TicketResponse apiTicket(String bankId, String accessToken, TicketRequest tr) throws Exception {
        return this.apiTicket(bankId, "", accessToken, tr);
    }

    @Override
    public TicketResponse apiTicket(String bankId, String channel, String accessToken, TicketRequest tr) throws Exception {
        HttpClientHelperContainer container = HttpClientHelperContainer.getInstance(bankId, channel, this.configFilePath);
        HttpClientHelper httpClient = container.getHttpClientHelper(bankId, channel, this.configFilePath);
        HashMap<String, Object> params = new HashMap();
        params = BeanUtils.convertBeanToMap(tr);
        System.out.println("params=== " + params);
        String response = httpClient.doGet(String.valueOf(ConfigUtil.getBaseUrl(channel, bankId)) + "/ticket", params);
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        return (TicketResponse)gson.fromJson(response, TicketResponse.class);
    }

    @Override
    public TicketResponse vfTicket(String par) throws Exception {
        HttpClientHelperContainer container = HttpClientHelperContainer.getInstance("", "", this.configFilePath);
        HttpClientHelper httpClient = container.getHttpClientHelper("", "", this.configFilePath);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("par", par);
        params.put("app_id", "803ZAKFAC");
        String response = httpClient.doPost(String.valueOf(ConfigUtil.getBaseUrl("", "")) + "/verifyTicket", params);
        System.out.println("response = " + response);
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        return (TicketResponse)gson.fromJson(response, TicketResponse.class);
    }

    @Override
    public String signWithTicket(List<String> valueList, String apiTicket) {
        if (valueList == null) {
            throw new NullPointerException("valueList is null");
        }
        valueList.removeAll(Collections.singleton(null));
        valueList.add(apiTicket);
        Collections.sort(valueList);
        StringBuilder sb = new StringBuilder();
        for (String s : valueList) {
            sb.append(s);
        }
        return Hashing.sha1().hashString((CharSequence)sb, Charsets.UTF_8).toString().toUpperCase();
    }

    @Override
    public APIResponse sendRequest(String url, APIRequest request) throws Exception {
        return this.sendRequest("", "", url, request);
    }

    @Override
    public APIResponse sendRequest(String bankId, String url, APIRequest request) throws Exception {
        return this.sendRequest(bankId, "", url, request);
    }

    @Override
    public APIResponse sendRequest(String bankId, String channel, String url, APIRequest request) throws Exception {
        HttpClientHelperContainer container = HttpClientHelperContainer.getInstance(bankId, channel, this.configFilePath);
        HttpClientHelper httpClient = container.getHttpClientHelper(bankId, channel, this.configFilePath);
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        String response = httpClient.doPost(String.valueOf(ConfigUtil.getBaseUrl(channel, bankId)) + url, JsonDataUtil.encodeJsonData(gson.toJson((Object)request), bankId, channel));
        return (APIResponse)gson.fromJson(response, APIResponse.class);
    }

    @Override
    public APIResponse sendRequestNew(String url, APIRequest request) throws Exception {
        return this.sendRequestNew("", "", url, request);
    }

    @Override
    public APIResponse sendRequestNew(String bankId, String url, APIRequest request) throws Exception {
        return this.sendRequestNew(bankId, "", url, request);
    }

    @Override
    public APIResponse sendRequestNew(String bankId, String channel, String url, APIRequest request) throws Exception {
        HttpClientHelperContainer container = HttpClientHelperContainer.getInstance(bankId, channel, this.configFilePath);
        HttpClientHelper httpClient = container.getHttpClientHelper(bankId, channel, this.configFilePath);
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        String response = httpClient.doPost(String.valueOf(ConfigUtil.getBaseUrl(channel, bankId)) + url, JsonDataUtil.encodeJsonDataNew(gson.toJson((Object)request), bankId, channel));
        return (APIResponse)gson.fromJson(response, APIResponse.class);
    }

    public String getConfigFilePath() {
        return this.configFilePath;
    }

    public void setConfigFilePath(String configFilePath) {
        this.configFilePath = configFilePath;
    }

    @Override
    public TicketResponse verifyTicket(String appId, String userId, String accessToken, String nonce, String signagture) throws Exception {
        return this.verifyTicket("", appId, userId, accessToken, nonce, signagture);
    }

    @Override
    public TicketResponse verifyTicket(String bankId, String appId, String userId, String accessToken, String nonce, String signagture) throws Exception {
        return this.verifyTicket("", "", appId, userId, accessToken, nonce, signagture);
    }

    @Override
    public TicketResponse verifyTicket(String bankId, String channel, String appId, String userId, String accessToken, String nonce, String signagture) throws Exception {
        HttpClientHelperContainer container = HttpClientHelperContainer.getInstance(bankId, channel, this.configFilePath);
        HttpClientHelper httpClient = container.getHttpClientHelper(bankId, channel, this.configFilePath);
        HashMap<String, Object> params = new HashMap();
        TicketRequest tr = new TicketRequest();
        tr.setAccessToken(accessToken);
        tr.setAppId(appId);
        tr.setUserId(userId);
        tr.setNonce(nonce);
        tr.setSignagture(signagture);
        params = BeanUtils.convertBeanToMap(tr);
        String response = httpClient.doGet(String.valueOf(ConfigUtil.getBaseUrl(channel, bankId)) + "/verify", params);
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        return (TicketResponse)gson.fromJson(response, TicketResponse.class);
    }
}

