/*
 * Decompiled with CFR 0.152.
 */
package com.sccba.open.tokenAPI;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sccba.open.http.HttpClientHelper;
import com.sccba.open.http.HttpClientHelperContainer;
import com.sccba.open.token.AccessCodeRequest;
import com.sccba.open.token.AccessCodeResponse;
import com.sccba.open.token.UserInfoRequest;
import com.sccba.open.token.UserInfoResponse;
import com.sccba.open.token.UserTokenRequest;
import com.sccba.open.token.UserTokenResponse;
import com.sccba.open.token.token;
import com.sccba.open.util.BeanUtils;
import com.sccba.open.util.ConfigUtil;
import java.util.HashMap;

public class TokenAPI
implements token {
    private String configFilePath = "";

    public TokenAPI() {
    }

    public TokenAPI(String configFilePath) {
        this.configFilePath = configFilePath;
    }

    @Override
    public AccessCodeResponse accessCode(String bankId, String channelId, String customerId, String merchantId) throws Exception {
        HashMap<String, Object> params = new HashMap();
        HttpClientHelperContainer container = HttpClientHelperContainer.getInstance(bankId, channelId, this.configFilePath);
        HttpClientHelper httpClient = container.getHttpClientHelper(bankId, channelId, this.configFilePath);
        AccessCodeRequest ac = new AccessCodeRequest();
        ac.setBankId(bankId);
        ac.setChannelId(channelId);
        ac.setCustomerId(customerId);
        ac.setMerchantId(merchantId);
        params = BeanUtils.convertBeanToMap(ac);
        String response = httpClient.doGet(String.valueOf(ConfigUtil.getBaseUrl(channelId, bankId)) + "/ac", params);
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        return (AccessCodeResponse)gson.fromJson(response, AccessCodeResponse.class);
    }

    @Override
    public UserTokenResponse userToken(String accessCode, String channelId, String merchantId, String bankId) throws Exception {
        HashMap<String, Object> params = new HashMap();
        HttpClientHelperContainer container = HttpClientHelperContainer.getInstance(bankId, channelId, this.configFilePath);
        HttpClientHelper httpClient = container.getHttpClientHelper(bankId, channelId, this.configFilePath);
        UserTokenRequest ut = new UserTokenRequest();
        ut.setBankId(bankId);
        ut.setMerchantId(merchantId);
        ut.setAccessCode(accessCode);
        ut.setGrantType("code");
        params = BeanUtils.convertBeanToMap(ut);
        String response = httpClient.doPost(String.valueOf(ConfigUtil.getBaseUrl(channelId, bankId)) + "/accessToken", params);
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        return (UserTokenResponse)gson.fromJson(response, UserTokenResponse.class);
    }

    @Override
    public UserInfoResponse userInfo(String accessToken, String transchannel, String merchantId, String bankId) throws Exception {
        HashMap<String, Object> params = new HashMap();
        HttpClientHelperContainer container = HttpClientHelperContainer.getInstance(bankId, transchannel, this.configFilePath);
        HttpClientHelper httpClient = container.getHttpClientHelper(bankId, transchannel, this.configFilePath);
        UserInfoRequest ui = new UserInfoRequest();
        ui.setBankId(bankId);
        ui.setMerchantId(merchantId);
        ui.setAccessToken(accessToken);
        ui.setTranschannel(transchannel);
        params = BeanUtils.convertBeanToMap(ui);
        String response = httpClient.doGet(String.valueOf(ConfigUtil.getBaseUrl(transchannel, bankId)) + "/info", params);
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        return (UserInfoResponse)gson.fromJson(response, UserInfoResponse.class);
    }
}

