/*
 * Decompiled with CFR 0.152.
 */
package com.sccba.open.util;

import com.google.gson.annotations.SerializedName;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class BeanUtils {
    public static Object convertMapToBean(Object bean, Map properties) throws IllegalAccessException, InvocationTargetException {
        org.apache.commons.beanutils.BeanUtils.populate((Object)bean, (Map)properties);
        return bean;
    }

    public static Map convertBeanToMap(Object bean) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, IntrospectionException, NoSuchFieldException {
        Class<?> type = bean.getClass();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        BeanInfo beanInfo = Introspector.getBeanInfo(type);
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        int i = 0;
        while (i < propertyDescriptors.length) {
            PropertyDescriptor descriptor = propertyDescriptors[i];
            String propertyName = descriptor.getName();
            if (!"Class".equalsIgnoreCase(propertyName)) {
                try {
                    Field file = type.getDeclaredField(propertyName);
                    SerializedName serializedName = file.getAnnotation(SerializedName.class);
                    if (!BeanUtils.isEmpty(serializedName.value())) {
                        propertyName = serializedName.value();
                    }
                }
                catch (NoSuchFieldException e) {
                    throw e;
                }
                catch (SecurityException e) {
                    throw e;
                }
                Method readMethod = descriptor.getReadMethod();
                Object result = readMethod.invoke(bean, new Object[0]);
                if (result != null) {
                    returnMap.put(propertyName, result);
                } else {
                    returnMap.put(propertyName, "");
                }
            }
            ++i;
        }
        return returnMap;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

