/*
 * Decompiled with CFR 0.152.
 */
package com.sccba.open.util;

import com.sccba.open.util.LoggerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class ConfigUtil {
    public static int iProviderType = 0;
    private static final String ibmJavaVmVendor = "IBM Corporation";
    private static Properties properties;
    private static ResourceBundle bundle;
    private static boolean isResourceMode;
    public static final String APPID = "appId";
    public static final String SECRET = "secret";
    public static final String HTTPS_FLAG = "https_flag";
    private static String propertiesFile;
    public static final String AHEAD_OF_TIME = "aheadoftime";
    public static final String SDK_PUBLIC_KEY_PATH = "pubilc.encryptCert.path";
    public static final String SDK_PRIVATE_PATH = "private.encryptCert.path";
    public static final String SDK_TRUST_STORE_BASE = "mTrustStoreBase.path";
    public static final String SDK_TRUST_STORE = "mTrustStore.path";
    public static final String SDK_TRUST_STORE_1 = "mTrustStore1.path";
    public static final String SDK_TRUST_STORE_2 = "mTrustStore2.path";
    public static final String SDK_CLIENT_STORE = "mClientKeyStore.path";
    public static final String SDK_CLIENT_STORE_PWD = "mClientKeyStorePwd.pwd";
    public static final String SDK_TRUST_STORE_PWD = "mTrustKeyStorePwd.pwd";
    public static final String SDK_KEY_STORE_TYPE = "sslKeyStoreType.type";
    public static final String HTTPCLIENT_BASEURL = "httpClient.baseUrl";
    public static final String HTTPCLIENT_MAXTOTALPOOL = "httpClient.maxTotalPool";
    public static final String HTTPCLIENT_MAXCONPERROUTE = "httpClient.maxConPerRoute";
    public static final String HTTPCLIENT_SOCKETTIMEOUT = "httpClient.socketTimeout";
    public static final String HTTPCLIENT_CONNECTIONREQUESTTIMEOUT = "httpClient.connectionRequestTimeout";
    public static final String HTTPCLIENT_CONNECTTIMEOUT = "httpClient.connectTimeout";
    public static final String HTTPCLIENT_PROXYIP = "httpClient.proxyIp";
    public static final String HTTPCLIENT_PROXYPORT = "httpClient.proxyPort";
    private static long propertiesLastTime;

    static {
        isResourceMode = true;
        propertiesFile = "sccba_open_api.properties";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void initProperties(String path) throws Exception {
        in = null;
        ConfigUtil.getVendorType();
        if (ConfigUtil.isResourceMode) {
            ConfigUtil.bundle = ResourceBundle.getBundle("com.sccba.open.resource." + path);
        } else {
            file = new File(String.valueOf(path) + File.separator + ConfigUtil.propertiesFile);
            if (file.exists()) {
                time = file.lastModified();
                if (ConfigUtil.propertiesLastTime != time) {
                    var5_5 = ConfigUtil.class;
                    synchronized (ConfigUtil.class) {
                        if (ConfigUtil.propertiesLastTime != time) {
                            block51: {
                                try {
                                    in = new FileInputStream(file);
                                    ConfigUtil.properties = new Properties();
                                    ConfigUtil.properties.load(in);
                                }
                                catch (FileNotFoundException e) {
                                    LoggerUtil.log(LoggerUtil.ERROR, "==initProperties error==" + e.getMessage(), e);
                                    if (in == null) {
                                        if (in != null) {
                                            try {
                                                in.close();
                                            }
                                            catch (IOException var9_12) {
                                                // empty catch block
                                            }
                                        }
                                        // ** MonitorExit[var5_5] (shouldn't be in output)
                                        return;
                                    }
                                    try {
                                        in.close();
                                    }
                                    catch (IOException var7_18) {
                                        // empty catch block
                                    }
                                    break block51;
                                }
                                catch (IOException e) {
                                    block52: {
                                        block53: {
                                            LoggerUtil.log(LoggerUtil.ERROR, "==initProperties error==" + e.getMessage(), e);
                                            if (in != null) break block52;
                                            if (in == null) break block53;
                                            {
                                                catch (Throwable var8_20) {
                                                    throw var8_20;
                                                }
                                            }
                                            try {
                                                in.close();
                                            }
                                            catch (IOException var9_14) {
                                                // empty catch block
                                            }
                                        }
                                        // ** MonitorExit[var5_5] (shouldn't be in output)
                                        return;
                                    }
                                    try {
                                        in.close();
                                    }
                                    catch (IOException var7_19) {
                                        // empty catch block
                                    }
                                    ** if (in == null) goto lbl-1000
lbl-1000:
                                    // 1 sources

                                    {
                                        try {
                                            in.close();
                                        }
                                        catch (IOException var9_15) {}
                                    }
lbl-1000:
                                    // 2 sources

                                    {
                                        break block51;
                                    }
                                }
                                {
                                    finally {
                                        if (in != null) {
                                            try {
                                                in.close();
                                            }
                                            catch (IOException var9_13) {}
                                        }
                                    }
                                }
                                if (in == null) break block51;
                                try {
                                    in.close();
                                }
                                catch (IOException var9_17) {
                                    // empty catch block
                                }
                            }
                            try {
                                in.close();
                            }
                            catch (IOException var6_11) {
                                // empty catch block
                            }
                        }
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                    }
                }
            } else {
                in = ConfigUtil.class.getClassLoader().getResourceAsStream(path);
                ConfigUtil.properties = new Properties();
                try {
                    try {
                        ConfigUtil.properties.load(in);
                    }
                    catch (IOException e) {
                        LoggerUtil.log(LoggerUtil.ERROR, "==initProperties error==" + e.getMessage(), e);
                        try {
                            in.close();
                        }
                        catch (IOException var5_6) {}
                    }
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException var5_8) {}
                }
            }
        }
        {
            return;
        }
    }

    public static String getBaseUrl(String channel, String bkId) throws Exception {
        return ConfigUtil.getProperty(HTTPCLIENT_BASEURL, channel, bkId);
    }

    public static int getMaxTotalPool(String channel, String bkId) throws Exception {
        return Integer.valueOf(ConfigUtil.getProperty(HTTPCLIENT_MAXTOTALPOOL, channel, bkId));
    }

    public static int getMaxConPerRoute(String channel, String bkId) throws Exception {
        return Integer.valueOf(ConfigUtil.getProperty(HTTPCLIENT_MAXCONPERROUTE, channel, bkId));
    }

    public static int getSocketTimeout(String channel, String bkId) throws Exception {
        return Integer.valueOf(ConfigUtil.getProperty(HTTPCLIENT_SOCKETTIMEOUT, channel, bkId));
    }

    public static int getConnectionRequestTimeout(String channel, String bkId) throws Exception {
        return Integer.valueOf(ConfigUtil.getProperty(HTTPCLIENT_CONNECTIONREQUESTTIMEOUT, channel, bkId));
    }

    public static int getConnectTimeout(String channel, String bkId) throws Exception {
        return Integer.valueOf(ConfigUtil.getProperty(HTTPCLIENT_CONNECTTIMEOUT, channel, bkId));
    }

    public static String getProxyIp(String channel, String bkId) throws Exception {
        return ConfigUtil.getProperty(HTTPCLIENT_PROXYIP, channel, bkId);
    }

    public static int getProxyPort(String channel, String bkId) throws Exception {
        return Integer.valueOf("".equals(ConfigUtil.getProperty(HTTPCLIENT_PROXYPORT, channel, bkId)) ? "0" : ConfigUtil.getProperty(HTTPCLIENT_PROXYPORT, channel, bkId));
    }

    private static int getVendorType() {
        Properties tSysProperties = System.getProperties();
        String tJvmVendor = tSysProperties.getProperty("java.vm.vendor");
        iProviderType = tJvmVendor.equals(ibmJavaVmVendor) ? 1 : 0;
        return iProviderType;
    }

    public static String getAppId(String channel, String bkId) throws Exception {
        return ConfigUtil.getProperty(APPID, channel, bkId);
    }

    public static String getAppSecret(String channel, String bkId) throws Exception {
        return ConfigUtil.getProperty(SECRET, channel, bkId);
    }

    public static String getAppId() {
        return ConfigUtil.getProperty(APPID);
    }

    public static String getAppSecret() {
        return ConfigUtil.getProperty(SECRET);
    }

    public static String getAheadOfTime() {
        return ConfigUtil.getProperty(AHEAD_OF_TIME);
    }

    public static String getHttpsFlag(String channel, String bkId) throws Exception {
        return ConfigUtil.getProperty(HTTPS_FLAG, channel, bkId);
    }

    public static String getProperty(String param, String channel, String bankId) throws Exception {
        String value = "";
        if (isResourceMode) {
            try {
                value = bundle.getString(String.valueOf(param) + ConfigUtil.dealParamWithKey(channel) + ConfigUtil.dealParamWithKey(bankId));
            }
            catch (MissingResourceException e) {
                try {
                    value = bundle.getString(param);
                }
                catch (MissingResourceException e1) {
                    value = "";
                }
            }
        } else {
            value = properties.getProperty(String.valueOf(param) + ConfigUtil.dealParamWithKey(channel) + ConfigUtil.dealParamWithKey(bankId));
            if (ConfigUtil.isEmpty(value)) {
                value = properties.getProperty(param);
            }
        }
        return ConfigUtil.trim2Empty(value).trim();
    }

    public static String getProperty(String param) {
        String value = "";
        if (isResourceMode) {
            try {
                value = bundle.getString(param);
            }
            catch (MissingResourceException e1) {
                value = "";
            }
        } else {
            value = properties.getProperty(param);
        }
        return ConfigUtil.trim2Empty(value).trim();
    }

    private static String dealParamWithKey(String key) {
        if (ConfigUtil.trim2Empty(key).length() == 0) {
            return "";
        }
        return "_" + ConfigUtil.trim2Empty(key);
    }

    public static boolean isEmpty(String s) {
        return s == null || "".equals(s.trim());
    }

    public static boolean isNotEmpty(String str) {
        return !ConfigUtil.isEmpty(str);
    }

    public static String trim2Empty(String str) {
        if (str == null || "null".equalsIgnoreCase(str.trim())) {
            return "";
        }
        return str.trim();
    }

    public static String getKey(String channel, String bankId) {
        if (channel != null && !"".equals(channel) && bankId != null && !"".equals(bankId)) {
            return String.valueOf(channel) + "_" + bankId;
        }
        if (channel != null && !"".equals(channel)) {
            return channel;
        }
        if (bankId != null && !"".equals(bankId)) {
            return bankId;
        }
        return "";
    }

    public static Properties getProperties() {
        return properties;
    }

    public static String getPublicKeyPath(String channel, String bkId) throws Exception {
        return ConfigUtil.getProperty(SDK_PUBLIC_KEY_PATH, channel, bkId);
    }

    public static String getPrivateKeyPath(String channel, String bkId) throws Exception {
        return ConfigUtil.getProperty(SDK_PRIVATE_PATH, channel, bkId);
    }

    public static String getTrustStore(String channel, String bkId) throws Exception {
        return ConfigUtil.getProperty(SDK_TRUST_STORE, channel, bkId);
    }

    public static String getTrustStore1(String channel, String bkId) throws Exception {
        return ConfigUtil.getProperty(SDK_TRUST_STORE_1, channel, bkId);
    }

    public static String getTrustStore2(String channel, String bkId) throws Exception {
        return ConfigUtil.getProperty(SDK_TRUST_STORE_2, channel, bkId);
    }

    public static String getTrustStoreBase(String channel, String bkId) throws Exception {
        return ConfigUtil.getProperty(SDK_TRUST_STORE_BASE, channel, bkId);
    }

    public static String getClientStore(String channel, String bkId) throws Exception {
        return ConfigUtil.getProperty(SDK_CLIENT_STORE, channel, bkId);
    }

    public static String getClientStorePwd(String channel, String bkId) throws Exception {
        return ConfigUtil.getProperty(SDK_CLIENT_STORE_PWD, channel, bkId);
    }

    public static String getMTrustKeyStorePwd(String channel, String bkId) throws Exception {
        return ConfigUtil.getProperty(SDK_TRUST_STORE_PWD, channel, bkId);
    }

    public static String getKeyStoreType(String channel, String bkId) throws Exception {
        return ConfigUtil.getProperty(SDK_KEY_STORE_TYPE, channel, bkId);
    }

    public static String getKeyStoreType() throws Exception {
        return ConfigUtil.getProperty(SDK_KEY_STORE_TYPE);
    }

    public static ResourceBundle getBundle() {
        return bundle;
    }

    public static void setBundle(ResourceBundle bundle) {
        ConfigUtil.bundle = bundle;
    }

    public static boolean isResourceMode() {
        return isResourceMode;
    }

    public static void setResourceMode(boolean isResourceMode) {
        ConfigUtil.isResourceMode = isResourceMode;
    }
}

