/*
 * Decompiled with CFR 0.152.
 */
package com.sccba.open.util;

import com.sccba.open.util.Base64;
import com.sccba.open.util.LoggerUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;

public class EncryptUtil {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String RSA_ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "SHA1withRSA";

    public static Key loadKey(InputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = null;
        try {
            Key key;
            ois = new ObjectInputStream(in);
            Key key2 = key = (Key)ois.readObject();
            return key2;
        }
        catch (ClassNotFoundException e) {
            LoggerUtil.log(LoggerUtil.ERROR, "==loadKey error==" + e.getMessage(), e);
            throw e;
        }
        finally {
            if (ois != null) {
                ois.close();
            }
        }
    }

    public static Key loadPublicKey(String publicKeyStr) throws NoSuchAlgorithmException, InvalidKeySpecException, NullPointerException {
        try {
            byte[] buffer = Base64.decode(publicKeyStr);
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            LoggerUtil.log(LoggerUtil.ERROR, "==loadPublicKey error==" + e.getMessage(), e);
            throw e;
        }
        catch (InvalidKeySpecException e) {
            LoggerUtil.log(LoggerUtil.ERROR, "==loadPublicKey error==" + e.getMessage(), e);
            throw e;
        }
        catch (NullPointerException e) {
            LoggerUtil.log(LoggerUtil.ERROR, "==loadPublicKey error==" + e.getMessage(), e);
            throw e;
        }
    }

    public static Key loadPrivateKey(String privateKeyStr) throws NoSuchAlgorithmException, InvalidKeySpecException, NullPointerException {
        try {
            byte[] buffer = Base64.decode(privateKeyStr);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(buffer);
            KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            LoggerUtil.log(LoggerUtil.ERROR, "==loadPrivateKey error==" + e.getMessage(), e);
            throw e;
        }
        catch (InvalidKeySpecException e) {
            LoggerUtil.log(LoggerUtil.ERROR, "==loadPrivateKey error==" + e.getMessage(), e);
            throw e;
        }
        catch (NullPointerException e) {
            LoggerUtil.log(LoggerUtil.ERROR, "==loadPrivateKey error==" + e.getMessage(), e);
            throw e;
        }
    }

    public static String loadKeyString(InputStream is) throws IOException, NullPointerException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(is));
            String readLine = null;
            StringBuilder sb = new StringBuilder();
            while ((readLine = br.readLine()) != null) {
                if (readLine.charAt(0) == '-') continue;
                sb.append(readLine);
                sb.append('\r');
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            LoggerUtil.log(LoggerUtil.ERROR, "==loadKeyString error==" + e.getMessage(), e);
            throw e;
        }
        catch (NullPointerException e) {
            LoggerUtil.log(LoggerUtil.ERROR, "==loadKeyString error==" + e.getMessage(), e);
            throw e;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    public static InputStream getInputStream(String filePath) throws FileNotFoundException {
        if (filePath == null || "".equals(filePath)) {
            return new FileInputStream(filePath);
        }
        return null;
    }

    public static byte[] encrypt(Key key, byte[] src) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException, NoSuchAlgorithmException {
        if (src == null || src.length == 0) {
            LoggerUtil.log(LoggerUtil.ERROR, "==encrypt error jsonData is null");
            throw new IllegalArgumentException("\u62a5\u6587\u4e3a\u7a7a");
        }
        try {
            Cipher ciper = Cipher.getInstance(RSA_ALGORITHM);
            ciper.init(1, key);
            return ciper.doFinal(src);
        }
        catch (NoSuchAlgorithmException e) {
            LoggerUtil.log(LoggerUtil.ERROR, "==encrypt error==" + e.getMessage(), e);
            throw e;
        }
        catch (NoSuchPaddingException e) {
            LoggerUtil.log(LoggerUtil.ERROR, "==encrypt error==" + e.getMessage(), e);
            throw e;
        }
        catch (InvalidKeyException e) {
            LoggerUtil.log(LoggerUtil.ERROR, "==encrypt error==" + e.getMessage(), e);
            throw e;
        }
        catch (IllegalBlockSizeException e) {
            LoggerUtil.log(LoggerUtil.ERROR, "==encrypt error==" + e.getMessage(), e);
            throw e;
        }
        catch (BadPaddingException e) {
            LoggerUtil.log(LoggerUtil.ERROR, "==encrypt error==" + e.getMessage(), e);
            throw e;
        }
    }

    public static byte[] decrypt(Key privateKey, byte[] src) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException {
        try {
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(2, privateKey);
            return cipher.doFinal(src);
        }
        catch (NoSuchAlgorithmException e) {
            LoggerUtil.log(LoggerUtil.ERROR, "==decrypt error==" + e.getMessage(), e);
            throw e;
        }
        catch (NoSuchPaddingException e) {
            LoggerUtil.log(LoggerUtil.ERROR, "==decrypt error==" + e.getMessage(), e);
            throw e;
        }
        catch (InvalidKeyException e) {
            LoggerUtil.log(LoggerUtil.ERROR, "==decrypt error==" + e.getMessage(), e);
            throw e;
        }
        catch (IllegalBlockSizeException e) {
            LoggerUtil.log(LoggerUtil.ERROR, "==decrypt error==" + e.getMessage(), e);
            throw e;
        }
        catch (BadPaddingException e) {
            LoggerUtil.log(LoggerUtil.ERROR, "==decrypt error==" + e.getMessage(), e);
            throw e;
        }
    }

    public static byte[] encrypt(byte[] src, String password) throws UnsupportedEncodingException, InvalidKeyException, InvalidKeySpecException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        try {
            DESedeKeySpec dks = new DESedeKeySpec(password.getBytes(DEFAULT_CHARSET));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
            SecretKey securekey = keyFactory.generateSecret(dks);
            Cipher cipher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
            cipher.init(1, securekey);
            return cipher.doFinal(src);
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (InvalidKeySpecException e) {
            throw e;
        }
        catch (InvalidKeyException e) {
            throw e;
        }
        catch (NoSuchAlgorithmException e) {
            throw e;
        }
        catch (NoSuchPaddingException e) {
            throw e;
        }
        catch (IllegalBlockSizeException e) {
            throw e;
        }
        catch (BadPaddingException e) {
            throw e;
        }
    }

    public static byte[] decrypt(byte[] content, String password) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException, InvalidKeySpecException {
        try {
            DESedeKeySpec dks = new DESedeKeySpec(password.getBytes(DEFAULT_CHARSET));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
            SecretKey securekey = keyFactory.generateSecret(dks);
            Cipher cipher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
            cipher.init(2, securekey);
            return cipher.doFinal(content);
        }
        catch (NoSuchAlgorithmException e) {
            throw e;
        }
        catch (NoSuchPaddingException e) {
            throw e;
        }
        catch (InvalidKeyException e) {
            throw e;
        }
        catch (IllegalBlockSizeException e) {
            throw e;
        }
        catch (BadPaddingException e) {
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (InvalidKeySpecException e) {
            throw e;
        }
    }

    public static String encode(byte[] src) {
        return Base64.encode(src);
    }

    public static byte[] decode(String src) {
        return Base64.decode(src);
    }

    public static String sign(byte[] data, String privateKey) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException {
        byte[] keyBytes = Base64.decode(privateKey.getBytes(DEFAULT_CHARSET));
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(priKey);
        signature.update(data);
        return new String(Base64.encode(signature.sign()));
    }

    public static boolean verify(byte[] data, String publicKey, String sign) throws Exception {
        byte[] keyBytes = Base64.decode(publicKey.getBytes(DEFAULT_CHARSET));
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        PublicKey pubKey = keyFactory.generatePublic(keySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(pubKey);
        signature.update(data);
        return signature.verify(Base64.decode(sign.getBytes(DEFAULT_CHARSET)));
    }

    public static boolean verify(byte[] data, Key publicKey, String sign) throws Exception {
        PublicKey pubKey = (PublicKey)publicKey;
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(pubKey);
        signature.update(data);
        return signature.verify(Base64.decode(sign.getBytes(DEFAULT_CHARSET)));
    }
}

