/*
 * Decompiled with CFR 0.152.
 */
package com.sccba.open.util;

import com.sccba.open.util.ConfigUtil;
import com.sccba.open.util.EncryptUtil;
import com.sccba.open.util.LoggerUtil;
import com.sccba.open.util.MD5Util;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class JsonDataUtil {
    public static Map<String, Object> encodeJsonData(String jsonData, String bankId, String channel) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        jsonData = JsonDataUtil.removeSpaceAndEnter(jsonData);
        String pwd = MD5Util.getMD5String(UUID.randomUUID().toString());
        String jsonDataBase64 = EncryptUtil.encode(EncryptUtil.encrypt(JsonDataUtil.getBytes(jsonData), pwd));
        InputStream publickKeyStream = null;
        InputStream privateKeyStream = null;
        try {
            try {
                publickKeyStream = JsonDataUtil.getFileInputStream(ConfigUtil.getPublicKeyPath(channel, bankId));
                privateKeyStream = JsonDataUtil.getFileInputStream(ConfigUtil.getPrivateKeyPath(channel, bankId));
                Key pubKey = EncryptUtil.loadPublicKey(EncryptUtil.loadKeyString(publickKeyStream));
                String passwordBase64 = EncryptUtil.encode(EncryptUtil.encrypt(pubKey, JsonDataUtil.getBytes(pwd)));
                String keyRandomLength = null;
                int temp = JsonDataUtil.removeSpaceAndEnter(passwordBase64).length();
                keyRandomLength = temp < 1000 ? "0" + temp : (temp < 100 ? "00" + temp : (temp < 10 ? "000" + temp : Integer.toString(temp)));
                Key priKey = EncryptUtil.loadPrivateKey(EncryptUtil.loadKeyString(privateKeyStream));
                String signatureBase64 = EncryptUtil.encode(JsonDataUtil.getBytes(EncryptUtil.sign(JsonDataUtil.getBytes(jsonData), EncryptUtil.encode(priKey.getEncoded()))));
                String jsondataString = "0" + keyRandomLength + passwordBase64 + jsonDataBase64;
                LoggerUtil.log(LoggerUtil.DEBUG, "==encode jsonData==" + jsondataString + "\n==encode signature==" + signatureBase64);
                params.put("jsonData", JsonDataUtil.removeSpaceAndEnter(jsondataString));
                params.put("signature", JsonDataUtil.removeSpaceAndEnter(signatureBase64));
            }
            catch (Exception e) {
                LoggerUtil.log(LoggerUtil.ERROR, "==encode jsonData error==" + e.getMessage(), e);
                if (privateKeyStream != null) {
                    privateKeyStream.close();
                }
                if (publickKeyStream != null) {
                    publickKeyStream.close();
                }
            }
        }
        finally {
            if (privateKeyStream != null) {
                privateKeyStream.close();
            }
            if (publickKeyStream != null) {
                publickKeyStream.close();
            }
        }
        return params;
    }

    public static Map<String, Object> encodeJsonDataNew(String jsonData, String bankId, String channel) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        jsonData = JsonDataUtil.removeSpaceAndEnter(jsonData);
        String pwd = MD5Util.getMD5String(UUID.randomUUID().toString());
        String jsonDataBase64 = EncryptUtil.encode(EncryptUtil.encrypt(JsonDataUtil.getBytes(jsonData), pwd));
        InputStream publickKeyStream = null;
        InputStream privateKeyStream = null;
        try {
            try {
                publickKeyStream = JsonDataUtil.getFileInputStream(ConfigUtil.getPublicKeyPath(channel, bankId));
                Key pubKey = EncryptUtil.loadPublicKey(EncryptUtil.loadKeyString(publickKeyStream));
                String passwordBase64 = EncryptUtil.encode(EncryptUtil.encrypt(pubKey, JsonDataUtil.getBytes(pwd)));
                String keyRandomLength = null;
                int temp = JsonDataUtil.removeSpaceAndEnter(passwordBase64).length();
                keyRandomLength = temp < 1000 ? "0" + temp : (temp < 100 ? "00" + temp : (temp < 10 ? "000" + temp : Integer.toString(temp)));
                String jsondataString = "0" + keyRandomLength + passwordBase64 + jsonDataBase64;
                LoggerUtil.log(LoggerUtil.DEBUG, "==encode jsonData==" + jsondataString);
                params.put("ver", "1.0.0.1");
                params.put("alg", "0".concat(passwordBase64));
                System.out.println("passwordBase64 = " + passwordBase64);
                params.put("enc_data", JsonDataUtil.removeSpaceAndEnter(jsonDataBase64));
            }
            catch (Exception e) {
                LoggerUtil.log(LoggerUtil.ERROR, "==encode jsonData error==" + e.getMessage(), e);
                if (privateKeyStream != null) {
                    privateKeyStream.close();
                }
                if (publickKeyStream != null) {
                    publickKeyStream.close();
                }
            }
        }
        finally {
            if (privateKeyStream != null) {
                privateKeyStream.close();
            }
            if (publickKeyStream != null) {
                publickKeyStream.close();
            }
        }
        return params;
    }

    private static String removeSpaceAndEnter(String s) {
        s = s.trim();
        s = s.replaceAll("\n", "");
        s = s.replaceAll("\r", "");
        return s;
    }

    private static byte[] getBytes(String str) throws UnsupportedEncodingException {
        return str.getBytes("UTF-8");
    }

    private static InputStream getFileInputStream(String path) throws FileNotFoundException {
        InputStream ins = JsonDataUtil.class.getResourceAsStream("/com/sccba/open/resource/cert/" + path);
        if (ins == null) {
            ins = new FileInputStream(path);
        }
        return ins;
    }
}

